% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{taylor_albums}
\alias{taylor_albums}
\title{Data for Taylor Swift's studio albums and EPs}
\format{
A \link[tibble:tibble-package]{tibble} with 13 rows
and 4 variables:
\itemize{
\item \code{album_name}: The name of the album. \code{NA} if the song was released
separately from one of Taylor's studio albums or EPs.
\item \code{ep}: Logical. Is the album a full studio album (\code{FALSE}) or an extended
play (\code{TRUE}).
\item \code{album_release}: The date the album was released, in the ISO-8601 format
(YYYY-MM-DD).
\item \code{metacritic_score}: The official album rating from metacritic.
}
}
\source{
\url{https://en.wikipedia.org/wiki/Taylor_Swift_albums_discography}

\url{https://www.metacritic.com/person/taylor-swift}
}
\usage{
taylor_albums
}
\description{
A data set containing the names of Taylor's official releases, the album
type, and release date.
}
\details{
This data set includes all official studio albums and EPs with new tracks.
This means that compilations or EPs that are a subset of the original albums
are not included (e.g., \emph{folklore: the escapism chapter},
\emph{folklore: the sleepless nights chapter}, etc.)
}
\keyword{datasets}
