% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tv2taxlist.R
\name{tv2taxlist}
\alias{tv2taxlist}
\title{Import species lists from Turboveg databases}
\usage{
tv2taxlist(taxlist, tv_home = tv.home(), ...)
}
\arguments{
\item{taxlist}{Character value indicating the name of a species list in
Turboveg.}

\item{tv_home}{Character value indicating the path to the main Turboveg
folder. By default the function \code{\link[=tv.home]{tv.home()}} from \link{vegdata-package} is
called.}

\item{...}{Further arguments passed to \code{\link[=df2taxlist]{df2taxlist()}}.}
}
\value{
A \linkS4class{taxlist} object.
}
\description{
Importing species lists from
\href{https://www.synbiosys.alterra.nl/turboveg/}{Turboveg 2} databases into a
\linkS4class{taxlist} object.

Internally the funcions \code{\link[=read.dbf]{read.dbf()}} and \code{\link[=df2taxlist]{df2taxlist()}} are called.
}
\examples{
## Cyperus data set installed as Turboveg species list
Cyperus <- tv2taxlist(taxlist = "cyperus",
  tv_home = file.path(path.package("taxlist"), "tv_data"))
Cyperus
}
\seealso{
\code{\link[=df2taxlist]{df2taxlist()}}
}
\author{
Miguel Alvarez \email{kamapu78@gmail.com}
}
