% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R, R/taxonomy.R
\name{[.taxa_classification}
\alias{[.taxa_classification}
\alias{[[.taxa_classification}
\alias{taxonomy}
\alias{names.taxa_taxonomy}
\alias{names<-.taxa_taxonomy}
\alias{[.taxa_taxonomy}
\alias{[[.taxa_taxonomy}
\title{Taxonomy class}
\usage{
\method{[}{taxa_classification}(x, ...)

\method{[[}{taxa_classification}(x, i)

taxonomy(taxa = taxon(), supertaxa = NA, .names = NULL)

\method{names}{taxa_taxonomy}(x)

\method{names}{taxa_taxonomy}(x) <- value

\method{[}{taxa_taxonomy}(x, ..., subtaxa = TRUE, supertaxa = FALSE, invert = FALSE)

\method{[[}{taxa_taxonomy}(x, i, ..., subtaxa = TRUE, supertaxa = FALSE, invert = FALSE)
}
\arguments{
\item{taxa}{A \link{taxon} vector or something that can be converted to a \link{taxon} vector.}

\item{supertaxa}{The indexes of \code{taxa} for each taxon's supertaxon.}

\item{.names}{The names of the vector (not the names of taxa).}
}
\value{
An \code{S3} object of class \code{taxa_taxon}
}
\description{
\Sexpr[results=rd, stage=render]{taxa:::lifecycle("experimental")}
Used to store information about a set of taxa forming a taxonomic tree.
}
\examples{

x <- taxonomy(c('Carnivora', 'Felidae', 'Panthera', 'Panthera leo',
                'Panthera tigris', 'Ursidae', 'Ursus', 'Ursus arctos'),
              supertaxa = c(NA, 1, 2, 3, 3, 1, 6, 7))

x <- taxonomy(taxon(name = c('Carnivora', 'Felidae', 'Panthera', 'Panthera leo',
                             'Panthera tigris', 'Ursidae', 'Ursus', 'Ursus arctos'),
                    rank = c('order', 'family', 'genus', 'species',
                             'species', 'family', 'genus', 'species'),
                    id = taxon_id(c('33554', '9681', '9688', '9689',
                                    '9694', '9632', '9639', '9644'),
                                  db = 'ncbi'),
                    auth = c('Bowdich, 1821', 'Fischer de Waldheim, 1817', 'Oken, 1816', 'L., 1758',
                             'L., 1758', 'Fischer de Waldheim, 1817', 'L., 1758', 'L., 1758')),
              supertaxa = c(NA, 1, 2, 3, 3, 1, 6, 7))
names(x) <- letters[1:8]

# Subset taxonomy vector
x[2] # By default, all subtaxa are included
x['b'] # Names can also be used
x[2:3, subtaxa = FALSE] # Disable subtaxa
x[3, supertaxa = TRUE] # include supertaxa
x[is_leaf(x)] # Subset by logical vector

# Get parts of the taxonomy vector
tax_name(x)
tax_rank(x)
tax_id(x)
tax_db(x)
tax_auth(x)
tax_author(x)
tax_date(x)
tax_cite(x)

# Set parts of the taxonomy vector
tax_name(x) <- tolower(tax_name(x))
tax_rank(x)[1] <- NA
tax_id(x) <- '9999'
tax_db(x) <- 'itis'
tax_auth(x) <- NA
tax_author(x)[2:3] <- c('Joe', 'Billy')
tax_date(x) <- c('1999', '2013', '1796', '1899',
                 '1997', '2003', '1996', '1859')
tax_cite(x)['c'] <- 'Linnaeus, C. (1771). Mantissa plantarum altera generum.'

# Convert to table
tibble::as_tibble(x)
as_data_frame(x)

# Get taxonomy attributes
subtaxa(x)
subtaxa(x, value = tax_name(x))
subtaxa(x, value = as_taxon(x))
n_subtaxa(x)
supertaxa(x)
n_supertaxa(x)
leaves(x)
n_leaves(x)
is_leaf(x)
stems(x)
is_stem(x)
roots(x)
is_root(x)
internodes(x)
is_internode(x)

}
\seealso{
Other classes: 
\code{\link{classification}()},
\code{\link{taxon_authority}()},
\code{\link{taxon_db}()},
\code{\link{taxon_id}()},
\code{\link{taxon_rank}()},
\code{\link{taxon}()}
}
\concept{classes}
\keyword{internal}
