context("walk_regions")


test_that("map_region works as expected", {
  source(file.path(test_path(), "testdata", "testdata.R"))

  x <- as_workbook(t_report_stack)
  style <- openxlsx::createStyle(fgFill = "#FF0000")

  walk_regions(x, .fun = openxlsx::addStyle, style = style)
  walk_regions(x, .fun = openxlsx::setColWidths, widths = 2)
  walk_regions(x, .fun = openxlsx::setRowHeights, heights = 32)


  expect_identical(
    x$rowHeights[[1]],
    structure(c("32", "32", "32", "32", "32", "32", "32", "32", "32",
      "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
      "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
      "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
      "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
      "32"), .Names = c("1", "2", "3", "4", "5", "7", "8", "9", "10",
      "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21",
      "22", "23", "24", "25", "26", "27", "30", "31", "32", "33", "34",
      "35", "38", "39", "40", "41", "42", "43", "44", "45", "48", "49",
      "50", "52", "53", "54", "55", "56", "57", "58", "59", "61", "63",
      "64"))
  )

  expect_identical(
    x$rowHeights[[2]],
    structure(c("32", "32", "32", "32", "32", "32", "32", "32", "32",
    "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
    "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
    "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
    "32", "32", "32", "32", "32", "32", "32", "32", "32", "32", "32",
    "32"), .Names = c("1", "2", "3", "4", "5", "7", "8", "9", "10",
    "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21",
    "22", "23", "24", "25", "26", "27", "35", "36", "37", "38", "39",
    "40", "48", "49", "50", "51", "52", "53", "54", "55", "63", "64",
    "65", "67", "68", "69", "70", "71", "72", "73", "74", "76", "78",
    "79"))
  )


  expect_identical(
    x$colWidths,
    list(structure(c("2", "2", "2", "2", "2", "2", "2", "2", "2",
    "2", "2", "2"), .Names = c("1", "2", "3", "4", "5", "6", "7",
    "8", "9", "10", "11", "12"), hidden = c("0", "0", "0", "0", "0",
    "0", "0", "0", "0", "0", "0", "0")), structure(c("2", "2", "2",
    "2", "2", "2", "2", "2", "2", "2", "2", "2"), .Names = c("1",
    "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"), hidden = c("0",
    "0", "0", "0", "0", "0", "0", "0", "0", "0", "0", "0")))
  )


  # Correct number of cells has been colored
  expect_identical(
    length(openxlsx::getStyles(x)),
    1066L
  )

  # openxlsx::openXL(x)
})
