% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskscheduleR.R
\name{taskcheduler_runnow}
\alias{taskcheduler_runnow}
\title{Immediately run a specific task available in the Windows task scheduler.}
\usage{
taskcheduler_runnow(taskname)
}
\arguments{
\item{taskname}{the name of the task to run. See the example.}
}
\value{
the system call to schtasks /Run
}
\description{
Immediately run a specific task available in the Windows task scheduler.
}
\examples{
\dontrun{
myscript <- system.file("extdata", "helloworld.R", package = "taskscheduleR")
taskscheduler_create(taskname = "myfancyscript", rscript = myscript, 
 schedule = "ONCE", starttime = format(Sys.time() + 10*60, "\%H:\%M"))

taskcheduler_runnow("myfancyscript")
Sys.sleep(5)
taskcheduler_stop("myfancyscript")


taskscheduler_delete(taskname = "myfancyscript")
}
}

