% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_unversion.R
\name{tar_unversion}
\alias{tar_unversion}
\title{Delete cloud object version IDs from local metadata.}
\usage{
tar_unversion(
  names = tidyselect::everything(),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{names}{Tidyselect expression to identify the targets to drop
version IDs.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Delete version IDs from local metadata.
}
\section{Cloud target data versioning}{

Some buckets in Amazon S3 or Google Cloud Storage are "versioned",
which means they track historical versions of each data object.
If you use \code{targets} with cloud storage
(\url{https://books.ropensci.org/targets/cloud-storage.html})
and versioning is turned on, then \code{targets} will record each
version of each target in its metadata.

Functions like \code{\link[=tar_read]{tar_read()}}
and \code{\link[=tar_load]{tar_load()}} load the version recorded in the local metadata,
which may not be the same as the "current" version of the
object in the bucket. Likewise, functions \code{\link[=tar_delete]{tar_delete()}}
and \code{\link[=tar_destroy]{tar_destroy()}} only remove
the version ID of each target as recorded in the local
metadata.

If you want to interact with the \emph{latest} version of an object
instead of the version ID recorded in the local metadata,
then you will need to delete the object from the metadata.
\enumerate{
\item Make sure your local copy of the metadata is current and
up to date. You may need to run \code{\link[=tar_meta_download]{tar_meta_download()}} or
\code{\link[=tar_meta_sync]{tar_meta_sync()}} first.
\item Run \code{\link[=tar_unversion]{tar_unversion()}} to remove the recorded version IDs of
your targets in the local metadata.
\item With the version IDs gone from the local metadata,
functions like \code{\link[=tar_read]{tar_read()}} and \code{\link[=tar_destroy]{tar_destroy()}} will use the
\emph{latest} version of each target data object.
\item Optional: to back up the local metadata file with the version IDs
deleted, use \code{\link[=tar_meta_upload]{tar_meta_upload()}}.
}
}

\seealso{
Other clean: 
\code{\link{tar_delete}()},
\code{\link{tar_destroy}()},
\code{\link{tar_invalidate}()},
\code{\link{tar_prune_list}()},
\code{\link{tar_prune}()}
}
\concept{clean}
