% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_path_store.R
\name{tar_path_store}
\alias{tar_path_store}
\title{Current data store path}
\usage{
tar_path_store()
}
\value{
Character, file path to the data store
of the pipeline currently running.
If called outside of the pipeline currently running,
\code{tar_path_store()} returns \code{tar_config_get("store")}.
}
\description{
Identify the file path to the data store
of the pipeline currently running.
}
\examples{
tar_path_store()
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(tar_target(x, tar_path_store()), ask = FALSE)
store <- tempfile()
tar_make(store = store)
tar_read(x, store = store)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_target}()},
\code{\link{tar_path}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
