% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_path_target.R
\name{tar_path_target}
\alias{tar_path_target}
\title{Identify the file path where a target will be stored.}
\usage{
tar_path_target(
  name = NULL,
  default = NA_character_,
  create_dir = FALSE,
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{name}{Symbol, name of a target.
If \code{NULL}, \code{tar_path_target()} returns the path of the target currently
running in a pipeline.}

\item{default}{Character, value to return if \code{tar_path_target()}
is called on its own outside a \code{targets} pipeline.
Having a default lets users run things without \code{\link[=tar_make]{tar_make()}},
which helps peel back layers of code and troubleshoot bugs.}

\item{create_dir}{Logical of length 1,
whether to create \code{dirname(tar_path_target())} in
\code{tar_path_target()} itself.
This is useful if you are writing to \code{tar_path_target()} from inside a
\code{storage = "none"} target and need the parent directory of the file
to exist.}

\item{store}{Character of length 1,
path to the data store if \code{tar_path_target()}
is called outside a running pipeline. If \code{tar_path_target()} is called
inside a running pipeline, this argument is ignored
and actual the path to the running pipeline's data store
is used instead.}
}
\value{
Character, file path of the return value of the target.
If not called from inside a running target,
\code{tar_path_target(name = your_target)} just returns
\verb{_targets/objects/your_target}, the file path where \code{your_target}
will be saved unless \code{format} is equal to \code{"file"} or any of the
supported cloud-based storage formats.

For non-cloud storage formats, if you call \code{tar_path_target()}
with no arguments while target \code{x} is running, the \code{name}
argument defaults to the name of the running target,
so \code{tar_path_target()} returns \verb{_targets/objects/x}.

For cloud-backed formats, \code{tar_path_target()} returns the
path to the staging file in \verb{_targets/scratch/}.
That way, even if you select a cloud repository
(e.g. \code{tar_target(..., repository = "aws", storage = "none")})
then you can still manually write to
\code{tar_path_target(create_dir = TRUE)}
and the \code{targets} package will automatically hash it and
upload it to the AWS S3 bucket. This does not apply to
\code{format = "file"}, where you would never need \code{storage = "none"}
anyway.
}
\description{
Identify the file path where a target will be stored
after the target finishes running in the pipeline.
}
\examples{
tar_path_target()
tar_path_target(your_target)
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script(tar_target(returns_path, tar_path_target()), ask = FALSE)
tar_make()
tar_read(returns_path)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path}()},
\code{\link{tar_seed}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
