tar_test("tar_config_set() reporter_make", {
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("reporter_make"), "verbose")
  tar_config_set(reporter_make = "summary")
  expect_equal(tar_config_get("reporter_make"), "summary")
  expect_true(file.exists("_targets.yaml"))
  expect_true(any(grepl("reporter_make", readLines("_targets.yaml"))))
  tar_config_set()
  expect_equal(tar_config_get("reporter_make"), "summary")
  expect_true(file.exists("_targets.yaml"))
  unlink("_targets.yaml")
  expect_equal(tar_config_get("reporter_make"), "verbose")
})

tar_test("tar_config_set() reporter_outdated", {
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("reporter_outdated"), "silent")
  tar_config_set(reporter_outdated = "forecast")
  expect_equal(tar_config_get("reporter_outdated"), "forecast")
  expect_true(file.exists("_targets.yaml"))
  expect_true(any(grepl("reporter_outdated", readLines("_targets.yaml"))))
  tar_config_set()
  expect_equal(tar_config_get("reporter_outdated"), "forecast")
  expect_true(file.exists("_targets.yaml"))
  unlink("_targets.yaml")
  expect_equal(tar_config_get("reporter_outdated"), "silent")
})

tar_test("tar_config_set() shortcut", {
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("shortcut"), FALSE)
  tar_config_set(shortcut = TRUE)
  expect_equal(tar_config_get("shortcut"), TRUE)
  expect_true(file.exists("_targets.yaml"))
  expect_true(any(grepl("shortcut", readLines("_targets.yaml"))))
  tar_config_set()
  expect_equal(tar_config_get("shortcut"), TRUE)
  expect_true(file.exists("_targets.yaml"))
  unlink("_targets.yaml")
  expect_equal(tar_config_get("shortcut"), FALSE)
})

tar_test("tar_config_set() with script", {
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("script"), path_script_default())
  path <- tempfile()
  tar_config_set(script = path)
  expect_equal(tar_config_get("script"), path)
  expect_true(file.exists("_targets.yaml"))
  tar_config_set()
  expect_equal(tar_config_get("script"), path)
  expect_true(file.exists("_targets.yaml"))
  unlink("_targets.yaml")
  expect_equal(tar_config_get("script"), path_script_default())
})

tar_test("tar_config_set() with script and different yaml file", {
  path <- tempfile()
  expect_false(file.exists(path))
  expect_equal(tar_config_get("script", config = path), path_script_default())
  path2 <- tempfile()
  tar_config_set(script = path2, config = path)
  expect_equal(tar_config_get("script", config = path), path2)
  expect_false(file.exists("_targets.yaml"))
  expect_true(file.exists(path))
  tar_config_set(config = path)
  expect_equal(tar_config_get("script", config = path), path2)
  expect_true(file.exists(path))
  expect_false(file.exists("_targets.yaml"))
  unlink(path)
  expect_equal(tar_config_get("script", config = path), path_script_default())
})

tar_test("tar_config_set() with store", {
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("store"), path_store_default())
  path <- tempfile()
  tar_config_set(store = path)
  expect_equal(tar_config_get("store"), path)
  expect_true(file.exists("_targets.yaml"))
  tar_config_set()
  expect_equal(tar_config_get("store"), path)
  expect_true(file.exists("_targets.yaml"))
  unlink("_targets.yaml")
  expect_equal(tar_config_get("store"), path_store_default())
})

tar_test("tar_config_set() with store and different yaml file", {
  path <- tempfile()
  expect_false(file.exists(path))
  expect_equal(tar_config_get("store", config = path), path_store_default())
  path2 <- tempfile()
  tar_config_set(store = path2, config = path)
  expect_equal(tar_config_get("store", config = path), path2)
  expect_false(file.exists("_targets.yaml"))
  expect_true(file.exists(path))
  tar_config_set(config = path)
  expect_equal(tar_config_get("store", config = path), path2)
  expect_true(file.exists(path))
  expect_false(file.exists("_targets.yaml"))
  unlink(path)
  expect_equal(tar_config_get("store", config = path), path_store_default())
})

tar_test("tar_config_set() workers", {
  expect_false(file.exists("_targets.yaml"))
  expect_equal(tar_config_get("workers"), 1L)
  tar_config_set(workers = 2L)
  expect_equal(tar_config_get("workers"), 2L)
  expect_true(file.exists("_targets.yaml"))
  expect_true(any(grepl("workers", readLines("_targets.yaml"))))
  tar_config_set()
  expect_equal(tar_config_get("workers"), 2L)
  expect_true(file.exists("_targets.yaml"))
  unlink("_targets.yaml")
  expect_equal(tar_config_get("workers"), 1L)
})

tar_test("_targets.yaml is locked during the pipeline then unlocked after", {
  tar_script({
    list(
      tar_target(a, "store: _targets2"),
      tar_target(x, writeLines(a, "_targets.yaml")),
      tar_target(y, x)
    )
  })
  tar_make(callr_function = NULL)
  expect_false(file.exists("_targets2"))
  expect_true(file.exists("_targets"))
  expect_equal(tar_config_get("store"), "_targets2")
  tar_config_set(store = "_targets")
  expect_equal(tar_config_get("store"), "_targets")
  expect_equal(tar_outdated(callr_function = NULL), character(0))
  tar_make(callr_function = NULL)
  expect_equal(unique(tar_progress()$progress), "skipped")
})

tar_test("same with external process", {
  tar_script({
    list(
      tar_target(a, "store: _targets2"),
      tar_target(x, writeLines(a, "_targets.yaml")),
      tar_target(y, x)
    )
  })
  tar_make(reporter = "silent")
  expect_false(file.exists("_targets2"))
  expect_true(file.exists("_targets"))
  expect_equal(tar_config_get("store"), "_targets2")
  tar_config_set(store = "_targets")
  expect_equal(tar_config_get("store"), "_targets")
  expect_equal(tar_outdated(callr_function = NULL), character(0))
  tar_make(callr_function = NULL)
  expect_equal(unique(tar_progress()$progress), "skipped")
})

tar_test("tar_config_set() can configure the script and the store", {
  skip_on_cran()
  tar_config_set(script = "example/script.R", store = "example/store")
  tar_script(tar_target(x, 1L))
  tar_make(reporter = "silent")
  expect_equal(tar_read(x), 1L)
  expect_true(file.exists("example/script.R"))
  expect_true(file.exists("example/store"))
  expect_false(file.exists(path_script_default()))
  expect_false(file.exists(path_store_default()))
})
