% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_name.R
\name{tar_name}
\alias{tar_name}
\title{Get the name of the target currently running.}
\usage{
tar_name(default = "target")
}
\arguments{
\item{default}{Character, value to return if \code{tar_name()}
is called on its own outside a \code{targets} pipeline.
Having a default lets users run things without \code{\link[=tar_make]{tar_make()}},
which helps peel back layers of code and troubleshoot bugs.}
}
\value{
Character of length 1. If called inside a pipeline,
\code{tar_name()} returns name of the target currently running.
Otherwise, the return value is \code{default}.
}
\description{
Get the name of the target currently running.
}
\examples{
tar_name()
tar_name(default = "custom_target_name")
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(tar_target(x, tar_name()), ask = FALSE)
tar_make()
tar_read(x)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_cancel}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_path}()},
\code{\link{tar_seed}()}
}
\concept{utilities}
