% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_config_get.R
\name{tar_config_get}
\alias{tar_config_get}
\title{Get configuration settings from _targets.yaml.}
\usage{
tar_config_get(name)
}
\arguments{
\item{name}{Character of length 1, name of the specific
\verb{_targets.yaml} configuration setting to retrieve.}
}
\value{
The value of the configuration setting from \verb{_targets.yaml},
or the default value if the setting is not available.
The data type of the return value depends on your choice
of \code{name}.
}
\description{
Read the custom settings in the optional _targets.yaml
configuration file at the current project.
}
\details{
\verb{_targets.yaml} is an optional YAML configuration file
with settings specific to a given project. You can write it
by hand or modify it with \code{\link[=tar_config_set]{tar_config_set()}}.
In order to work properly, \verb{_targets.yaml} must live at the
root of the project (next to \verb{_targets.R}).
The currently supported configuration settings are
documented as the arguments of \code{\link[=tar_config_set]{tar_config_set()}}.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)))
tar_config_get("store") # "_targets"
store_path <- tempfile()
tar_config_set(store = store_path)
tar_config_get("store") # Shows a temp file.
tar_make() # Writes to the custom data store identified in _targets.yaml.
tar_read(x) # tar_read() knows about _targets.yaml too.
file.exists("_targets") # FALSE
file.exists(store_path) # TRUE
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_set}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()},
\code{\link{tar_option_set}()}
}
\concept{configuration}
