% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_resources_gcp.R
\name{tar_resources_gcp}
\alias{tar_resources_gcp}
\title{Target resources: Google Cloud Platform (GCP)
Google Cloud Storage (GCS)}
\usage{
tar_resources_gcp(
  bucket,
  prefix = targets::path_objects_dir_cloud(),
  predefined_acl = "private",
  verbose = FALSE
)
}
\arguments{
\item{bucket}{Character of length 1, name of an existing
bucket to upload and download the return values
of the affected targets during the pipeline.}

\item{prefix}{Character of length 1, "directory path"
in the bucket where the target return values are stored.}

\item{predefined_acl}{Character of length 1, user access
to the object. See \code{?googleCloudStorageR::gcs_upload}
for possible values.}

\item{verbose}{Logical of length 1, whether to print
extra messages like progress bars during uploads
and downloads.}
}
\value{
Object of class \code{"tar_resources_gcp"}, to be supplied
to the \code{gcp} argument of \code{tar_resources()}.
}
\description{
Create the \code{gcp} argument of \code{tar_resources()}
to specify optional settings for Google Cloud Storage for
targets with \code{tar_target(..., repository = "gcp")}.
See the \code{format} argument of \code{\link[=tar_target]{tar_target()}} for details.
}
\details{
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
}
\section{Resources}{

Functions \code{\link[=tar_target]{tar_target()}} and \code{\link[=tar_option_set]{tar_option_set()}}
each takes an optional \code{resources} argument to supply
non-default settings of various optional backends for data storage
and high-performance computing. The \code{tar_resources()} function
is a helper to supply those settings in the correct manner.
Resources are all-or-nothing: if you specify any resources
with \code{\link[=tar_target]{tar_target()}}, all the resources from \code{tar_option_get("resources")}
are dropped for that target. In other words, if you write
\code{tar_option_set(resources = resources_1)} and then
\code{tar_target(x, my_command(), resources = resources_2)}, then everything
in \code{resources_1} is discarded for target \code{x}.
}

\examples{
# Somewhere in you target script file (usually _targets.R):
tar_target(
  name,
  command(),
  format = "qs",
  repository = "gcp",
  resources = tar_resources(
    gcp = tar_resources_gcp(bucket = "yourbucketname"),
    qs = tar_resources_qs(preset = "fast")
  )
)
}
\seealso{
Other resources: 
\code{\link{tar_resources_aws}()},
\code{\link{tar_resources_clustermq}()},
\code{\link{tar_resources_feather}()},
\code{\link{tar_resources_fst}()},
\code{\link{tar_resources_future}()},
\code{\link{tar_resources_parquet}()},
\code{\link{tar_resources_qs}()},
\code{\link{tar_resources_url}()},
\code{\link{tar_resources}()}
}
\concept{resources}
