% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_store.R
\name{tar_store}
\alias{tar_store}
\title{Current data store path}
\usage{
tar_store()
}
\value{
Character, file path to the data store
of the pipeline currently running.
If called outside of the pipeline currently running,
\code{tar_store()} returns \code{tar_config_get("store")}.
}
\description{
Identify the file path to the data store
of the pipeline currently running.
}
\examples{
tar_store()
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(tar_target(x, tar_store()), ask = FALSE)
store <- tempfile()
tar_make(store = store)
tar_read(x, store = store)
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_seed}()}
}
\concept{utilities}
