% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_deps.R
\name{tar_deps}
\alias{tar_deps}
\title{Code dependencies}
\usage{
tar_deps(expr)
}
\arguments{
\item{expr}{A quoted R expression or function.}
}
\value{
Character vector of the dependencies of a function or expression.
}
\description{
List the dependencies of a function or expression.
}
\details{
\code{targets} detects the dependencies of commands using
static code analysis. Use \code{tar_deps()} to run the
code analysis and see the dependencies for yourself.
}
\examples{
tar_deps(x <- y + z)
tar_deps({
  x <- 1
  x + a
})
tar_deps(function(a = b) map_dfr(data, ~do_row(.x)))
}
\seealso{
Other inspect: 
\code{\link{tar_deps_raw}()},
\code{\link{tar_glimpse}()},
\code{\link{tar_manifest}()},
\code{\link{tar_network}()},
\code{\link{tar_outdated}()},
\code{\link{tar_sitrep}()},
\code{\link{tar_validate}()},
\code{\link{tar_visnetwork}()}
}
\concept{inspect}
