% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_progress.R
\name{tar_progress}
\alias{tar_progress}
\title{Read the target progress of the latest run of the pipeline.}
\usage{
tar_progress(names = NULL)
}
\arguments{
\item{names}{Optional, names of the targets. If supplied, \code{tar_progress()}
only returns progress information on these targets.
You can supply symbols, a character vector,
or \code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}
}
\value{
A data frame with one row per target and the following columns:
\itemize{
\item \code{name}: name of the target or global object.
\item \code{progress}: the most recent progress update of that target.
Could be \code{"running"}, \code{"built"}, \code{"cancelled"}, or \code{"failed"}.
}
}
\description{
Read a project's target progress data for the most recent
run of \code{\link[=tar_make]{tar_make()}} or similar. Only the most recent record is shown.
}
\examples{
if (identical(Sys.getenv("TARGETS_LONG_EXAMPLES"), "true")) {
tar_dir({ # Write all files to a temporary directory.
tar_script(
  list(
    tar_target(x, seq_len(2)),
    tar_target(y, 2 * x, pattern = map(x))
  )
)
tar_make()
tar_progress()
tar_progress(starts_with("y_"))
})
}
}
