% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_row.R
\name{cat_row}
\alias{cat_row}
\title{Categorical Row}
\usage{
cat_row(
  list_obj,
  row_var,
  col_var = NULL,
  newdata = FALSE,
  rowlabel = NULL,
  summary = NULL,
  missing = NULL,
  overall = NULL,
  comparison = NULL,
  digits = 2,
  indent = 5
)
}
\arguments{
\item{list_obj}{the name of the \code{tbl_start} object previously initialized.}

\item{row_var}{the name of the variable to be used in the rows.}

\item{col_var}{the variable to be used in the table columns. Default is from initialized \code{tbl_start} object.}

\item{newdata}{enter new dataset name if different from that initialized in \code{tbl_start}.}

\item{rowlabel}{the label for the table row name, if different from \code{row_var}.}

\item{summary}{summary function for the data, if different from the one supplied in \code{tbl_start}.}

\item{missing}{logical: if TRUE, missing data is considered; FALSE only uses complete cases.}

\item{overall}{logical: if TRUE, an overall column is included.}

\item{comparison}{the name of the comparison test to use, if different from that initialized in \code{tbl_start}.}

\item{digits}{significant digits to use.}

\item{indent}{number of spaces to indent category names.}
}
\value{
A list with the categorical row's table information added as a new element to \code{list_obj}.
}
\description{
Adds in a categorical row to the table.
}
\examples{
iris$Stem.Size <- sample(c("Small", "Medium", "Medium", "Large"), size=150, replace=TRUE)
x <- tbl_start(iris, "Species", missing=TRUE, overall=TRUE, comparison=TRUE) \%>\%
  cat_row("Stem.Size", rowlabel="Stem Size")
}
\keyword{tangram.pipe}
