% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/employ.R
\name{employ}
\alias{employ}
\title{Employ a Clustering to New Data}
\usage{
employ(
  object,
  new_data,
  only = NULL,
  additional_data = NULL,
  assignment_method = "nearest_cluster",
  parallel = FALSE,
  ...
)
}
\arguments{
\item{object}{A \code{medic} clustering object for which employment is desired.}

\item{new_data}{A data frame in which to look for variables with}

\item{only}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Expressions that
return a logical value, and are defined in terms of the variables in
\code{object} and/or \code{additional_data} and specifies which clusterings should be
employed to the new data.}

\item{additional_data}{A data frame with additional data that may be
(left-)joined onto the \code{parameters} in \code{object}. This is often
used in conjuction with \code{only} to select specific clusterings based on
\code{additional_data}.}

\item{assignment_method}{A character naming the employment method. The
default assignment method \code{"nearest_cluster"} matches people in \code{new_data}
to their nearest cluster in the chosen clusterings from \code{object}. As
finding exact matches (the next assignment method) is contained within this
strategy the \code{"exact_only"} matches are also reported in additional columns
in the output.

The assignment method \code{"exact_only"} only matches a person from \code{new_data}
to a cluster if they are a perfect match to anyone in \code{object}. Thus,
people from \code{new_data} are not guaranteed assignment to a cluster.}

\item{parallel}{A logical or an integer. If \code{FALSE}, the default, no
parallelization is done.

If \code{TRUE} or an integer larger than 2L parallelization is implemented via
\link[parallel:clusterApply]{parLapply} from the \strong{parallel} package. When
\code{parallel} is \code{TRUE} the number of \link[parallel:makeCluster]{clusters}
is set to \link[parallel:detectCores]{detectCores} - 1, and when \code{parallel} is
an integer then the number of \link[parallel:makeCluster]{clusters} is set to
\code{parallel}. For more details on the parallelization method see
\link[parallel:clusterApply]{parallel::parLapply}.}

\item{...}{Additional arguments affecting the employment procedure.}
}
\value{
\code{employ} returns a medic object.
}
\description{
Employ a clustering to new data
}
\examples{
part1 <- complications[1:100,]
part2 <- complications[101:149,]

clust <- medic(part1, id = id, atc = atc, k = 3)

# Nearest cluster matching
employ(clust, part2)

# Only exact matching
employ(clust, part2, assignment_method = "exact_only")

}
