% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tadaa_plots.R
\name{tadaa_balance}
\alias{tadaa_balance}
\title{Grouping design balance}
\usage{
tadaa_balance(data, group1, group2, palette = "D", annotate = TRUE)
}
\arguments{
\item{data}{A \code{data.frame}}

\item{group1}{The grouping variable on the x-axis}

\item{group2}{The grouping variable on the y-axis}

\item{palette}{The \link[viridis:viridis]{viridis::viridis} color palette to use; \code{c("A", "B", "C", "D")},
defaults to \code{"D"}}

\item{annotate}{Should the n of each group be displayed in each cell of the heatmap?}
}
\value{
A ggplot2 object
}
\description{
Easily generate heatmaps to show how well balanced groups are designed, e.g. for ANOVA.
}
\examples{
tadaa_balance(ngo, jahrgang, geschl)
}
\seealso{
Other Tadaa-plot functions: \code{\link{tadaa_int}},
  \code{\link{tadaa_mean_ci}},
  \code{\link{tadaa_plot_tukey}}
}
