% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwplot2.R
\name{bwplot2}
\alias{bwplot2}
\alias{bwplot2.formula}
\alias{bwplot2.numeric}
\title{An extended box and whiskers plot}
\usage{
bwplot2(x, data = NULL, ...)

\method{bwplot2}{formula}(x, data = NULL, allow.multiple = is.null(groups)
  || outer, outer = FALSE, auto.key = FALSE, groups = NULL,
  drop.unused.levels = lattice.getOption("drop.unused.levels"), ...,
  subset = TRUE)

\method{bwplot2}{numeric}(x, data = NULL, xlab = deparse(substitute(x)),
  ...)
}
\arguments{
\item{x}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{data}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{...}{arguments passed down to \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{allow.multiple}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{outer}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{auto.key}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{groups}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{drop.unused.levels}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{subset}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}

\item{xlab}{see \code{\link[lattice:bwplot]{lattice::bwplot()}}}
}
\value{
An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.
}
\description{
An extended version of \code{\link[lattice:bwplot]{lattice::bwplot()}}. The only modification is to
group and stack box plots if \code{groups} is provided.
}
\examples{
bwplot2(variety ~ yield,
        groups = site,
        data = barley,
        par.settings = tactile.theme())
}
