% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble.R
\name{as_tibble}
\alias{as_tibble}
\alias{as_tibble.BasicRaster}
\title{Convert a Raster to a data frame.}
\usage{
\method{as_tibble}{BasicRaster}(
  x,
  cell = TRUE,
  dim = nlayers(x) > 1L,
  value = TRUE,
  split_date = FALSE,
  xy = FALSE,
  ...
)
}
\arguments{
\item{x}{a RasterLayer, RasterStack or RasterBrick}

\item{cell}{logical to include explicit cell number}

\item{dim}{logical to include slice index}

\item{value}{logical to return the values as a column or not}

\item{split_date}{logical to split date into components}

\item{xy}{logical to include the x and y centre coordinate of each cell}

\item{...}{unused}
}
\value{
a data frame (tibble) with columns:
\itemize{
\item \code{cellvalue} the actual value of the raster cell
\item \code{cellindex} the index of the cell (numbered from 1 to \code{ncell()} in the raster way).
}

Columns \code{cellindex} or \code{cellvalue} may be omitted if either or both of \code{cell} and/or \code{value} are \code{FALSE}, respectively

Other columns might be included depending on the properties of the raster and
the arguments to the function:
\itemize{
\item \code{year},\code{month},\code{day} if \code{split_date} is \code{TRUE}
\item \code{x},\code{y} if \code{xy} is \code{TRUE}
\item \code{dimindex} if the input has more than 1 layer and \code{dim} is \code{TRUE}.
}
}
\description{
Generate a data frame version of any raster object. Use the arguments
'cell', 'dim', 'split_date' and 'value' to control the columns that
are included in the output.
}
\details{
If the raster has only one layer, the slice index is not added. Use 'dim = FALSE' to not include
the slice index value.
}
\examples{
## basic data frame version of a basic raster
as_tibble(raster::raster(volcano))

## data frame with time column since raster has that set
r <- raster::raster(volcano)
br <- raster::brick(r, r)
as_tibble(raster::setZ(br, Sys.Date() + 1:2), cell = TRUE)
}
