% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/rarefaction.R
\docType{methods}
\name{plot_rarefaction}
\alias{plot_rarefaction}
\alias{plot,RarefactionIndex,missing-method}
\title{Rarefaction Plot}
\usage{
\S4method{plot}{RarefactionIndex,missing}(
  x,
  color = NULL,
  symbol = FALSE,
  main = NULL,
  sub = NULL,
  ann = graphics::par("ann"),
  axes = TRUE,
  frame.plot = axes,
  panel.first = NULL,
  panel.last = NULL,
  legend = list(x = "topleft"),
  ...
)
}
\arguments{
\item{x}{A \linkS4class{RarefactionIndex} object to be plotted.}

\item{color}{A vector of colors (will be mapped to the rownames of \code{object}).
If \code{color} is a named a named vector, then the colors will be associated
with the rownames of \code{object}. Ignored if set to \code{FALSE}.}

\item{symbol}{A specification for the line type (will be mapped to
the names of \code{x}). If \code{symbol} is a named a named vector, then the
line types will be associated with the names of \code{x}.
Ignored if set to \code{FALSE}.}

\item{main}{A \code{\link{character}} string giving a main title for the plot.}

\item{sub}{A \code{\link{character}} string giving a subtitle for the plot.}

\item{ann}{A \code{\link{logical}} scalar: should the default annotation (title and x,
y and z axis labels) appear on the plot?}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}

\item{frame.plot}{A \code{\link{logical}} scalar: should a box be drawn around the
plot?}

\item{panel.first}{An an \code{expression} to be evaluated after the plot axes are
set up but before any plotting takes place. This can be useful for drawing
background grids.}

\item{panel.last}{An \code{expression} to be evaluated after plotting has taken
place but before the axes, title and box are added.}

\item{legend}{A \code{\link{list}} of additional arguments to be passed to
\code{\link[graphics:legend]{graphics::legend()}}; names of the list are used as argument names.
If \code{NULL}, no legend is displayed.}

\item{...}{Further \link[graphics:par]{graphical parameters} to be passed to
\code{\link[graphics:lines]{graphics::lines()}}.}
}
\value{
\code{plot()} is called for its side-effects: it results in a graphic being
displayed (invisibly returns \code{x}).
}
\description{
Rarefaction Plot
}
\examples{
## Data from Conkey 1980, Kintigh 1989
data("cantabria")

## Replicate fig. 3 from Baxter 2011
rare <- rarefaction(cantabria, sample = 23, method = "baxter")
plot(rare, panel.first = graphics::grid())

## Change graphical parameters
plot(rare, color = color("bright")(5), symbol = 1:5)
}
\seealso{
Other diversity measures: 
\code{\link{heterogeneity}()},
\code{\link{occurrence}()},
\code{\link{plot_diversity}},
\code{\link{profiles}()},
\code{\link{rarefaction}()},
\code{\link{richness}()},
\code{\link{she}()},
\code{\link{similarity}()},
\code{\link{simulate}()},
\code{\link{turnover}()}
}
\author{
N. Frerebeau
}
\concept{diversity measures}
