% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/index_test.R
\docType{methods}
\name{test_diversity}
\alias{test_diversity}
\alias{test_diversity-method}
\alias{test_diversity,matrix-method}
\alias{test_diversity,data.frame-method}
\title{Diversity Test}
\usage{
test_diversity(object, ...)

\S4method{test_diversity}{matrix}(object, adjust = "holm", ...)

\S4method{test_diversity}{data.frame}(object, adjust = "holm", ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments to be passed to internal methods.}

\item{adjust}{A \code{\link{character}} string specifying the method for
adjusting \eqn{p} values (see \code{\link[stats:p.adjust]{stats::p.adjust()}}).}
}
\value{
A \code{\link{numeric}} \code{\link{matrix}}.
}
\description{
Compares Shannon diversity between samples.
}
\details{
This test produces two sided pairwise comparisons: it returns a matrix of
adjusted \eqn{p} values.
}
\examples{
data("cantabria")

## Shannon diversity test
test_diversity(cantabria)
}
\references{
Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
Princeton, NJ: Princeton University Press. \doi{10.1007/978-94-015-7358-0}.
}
\seealso{
Other statistics: 
\code{\link{independance}}
}
\author{
N. Frerebeau
}
\concept{statistics}
