# Heterogeneity

    Code
      boot
    Output
             original      mean         bias     error
      P610s 1.6681740 1.7980267  0.129852707 0.2187031
      P610e 1.2130076 0.9036067 -0.309400908 0.5498707
      P625  0.6931472 0.4773884 -0.215758739 0.4678097
      P630  0.0000000 0.2484907  0.248490665 0.4004797
      P307  0.0000000 0.1983548  0.198354752 0.3418904
      P631  1.7481555 1.7735665  0.025411031 0.2214460
      P623  1.0986123 1.0427455 -0.055866829 0.4647529
      P624  1.8711604 1.8187729 -0.052387474 0.1441418
      P626s 1.7207095 1.7390169  0.018307421 0.1916688
      P626e 1.9115521 1.9436108  0.032058649 0.1334031
      P627  1.0397208 0.9683696 -0.071351219 0.5011470
      P628  1.8200760 1.8230499  0.002973933 0.2200054

---

    Code
      jack
    Output
                 mean       bias     error
      P610s 1.5680395 -0.9012101 0.2056978
      P610e 1.1096729 -0.9300118 0.3968560
      P625  0.5545177 -1.2476649 0.8317766
      P630  0.0000000  0.0000000 0.0000000
      P307  0.0000000  0.0000000 0.0000000
      P631  1.6463856 -0.9159291 0.2108823
      P623  0.9769728 -1.0947558 0.5574224
      P624  1.7643489 -0.9613033 0.2126469
      P626s 1.6152716 -0.9489415 0.2242804
      P626e 1.8080769 -0.9312771 0.1429090
      P627  0.9244221 -1.0376881 0.5301829
      P628  1.7148123 -0.9473731 0.2085352

# Evenness

    Code
      boot
    Output
             original      mean        bias      error
      P610s 0.8572718 0.9154750 0.058203116 0.06004265
      P610e 0.8750000       NaN         NaN         NA
      P625  1.0000000       NaN         NaN         NA
      P630        NaN       NaN         NaN         NA
      P307        NaN       NaN         NaN         NA
      P631  0.8983742 0.9107919 0.012417726 0.03114999
      P623  1.0000000       NaN         NaN         NA
      P624  0.9615862 0.9664026 0.004816323 0.01565268
      P626s 0.8842698 0.9072256 0.022955831 0.04009881
      P626e 0.8699849 0.8829208 0.012935972 0.03978071
      P627  0.9463946       NaN         NaN         NA
      P628  0.9353340 0.9521520 0.016817938 0.02374790

---

    Code
      jack
    Output
                 mean          bias        error
      P610s 0.8530134 -3.832613e-02 3.467900e-02
      P610e 0.8725916 -2.167581e-02 1.055074e-01
      P625        NaN           NaN          NaN
      P630        NaN           NaN          NaN
      P307        NaN           NaN          NaN
      P631  0.8956783 -2.426312e-02 3.790426e-02
      P623  1.0000000  9.992007e-16 3.330669e-16
      P624  0.9598834 -1.532543e-02 1.972936e-02
      P626s 0.8786773 -5.033240e-02 4.931785e-02
      P626e 0.8645734 -4.870273e-02 4.770957e-02
      P627  0.9461354 -2.333001e-03 6.329892e-02
      P628  0.9329141 -2.177978e-02 1.598781e-02

# Berger-Parker dominance

    Code
      index_berger(n)
    Output
      [1] 0.254

# Brillouin diversity

    Code
      index_brillouin(n, evenness = FALSE)
    Output
      [1] 1.876307

---

    Code
      index_brillouin(n, evenness = TRUE)
    Output
      [1] 0.8275138

# McIntosh dominance

    Code
      index_mcintosh(n, evenness = FALSE)
    Output
      [1] 0.7066343

---

    Code
      index_mcintosh(n, evenness = TRUE)
    Output
      [1] 0.8180305

# Shannon diversity

    Code
      index_shannon(n, evenness = FALSE)
    Output
      [1] 2.407983

---

    Code
      index_shannon(n, evenness = TRUE)
    Output
      [1] 0.8038044

---

    Code
      variance_shannon(n)
    Output
      [1] 0.005400433

# Simpson dominance

    Code
      index_simpson(n)
    Output
      [1] 0.1176834

