% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot-diversity.R
\docType{methods}
\name{plot_diversity}
\alias{plot_diversity}
\alias{plot_diversity-method}
\alias{plot_diversity,DiversityIndex-method}
\title{Diversity Plot}
\usage{
plot_diversity(object, ...)

\S4method{plot_diversity}{DiversityIndex}(object)
}
\arguments{
\item{object}{A \linkS4class{DiversityIndex} object to be plotted.}

\item{...}{Currently not used.}
}
\description{
Diversity Plot
}
\examples{
library(magrittr)

merzbach \%>\%
  as_count() \%>\%
  index_evenness(method = "shannon", simulate = FALSE) \%>\%
  plot_diversity()

\donttest{
## Assemblage diversity size comparison
## Warning: this may take a few seconds!
merzbach \%>\%
  as_count() \%>\%
  index_evenness(method = "shannon", simulate = TRUE) \%>\%
  plot_diversity()

merzbach \%>\%
  as_count() \%>\%
  index_richness(method = "none", simulate = TRUE) \%>\%
  plot_diversity()
}
}
\seealso{
\link{index_heterogeneity}, \link{index_evenness},
 \link{index_richness}

Other plot: \code{\link{plot_bar}},
  \code{\link{plot_date}}, \code{\link{plot_line}},
  \code{\link{plot_matrix}}, \code{\link{plot_spot}}
}
\author{
N. Frerebeau
}
\concept{plot}
