% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/coerce.R
\docType{methods}
\name{coerce}
\alias{coerce}
\alias{as_count}
\alias{as_count-method}
\alias{as_frequency}
\alias{as_frequency-method}
\alias{as_incidence}
\alias{as_incidence-method}
\alias{as_occurrence}
\alias{as_occurrence-method}
\alias{as_similarity}
\alias{as_similarity-method}
\alias{as_count,ANY-method}
\alias{as_frequency,ANY-method}
\alias{as_incidence,ANY-method}
\alias{as_occurrence,ANY-method}
\alias{as_similarity,ANY-method}
\title{Coerce}
\usage{
as_count(from)

as_frequency(from)

as_incidence(from)

as_occurrence(from)

as_similarity(from)

\S4method{as_count}{ANY}(from)

\S4method{as_frequency}{ANY}(from)

\S4method{as_incidence}{ANY}(from)

\S4method{as_occurrence}{ANY}(from)

\S4method{as_similarity}{ANY}(from)
}
\arguments{
\item{from}{A numeric \code{\link{matrix}} or \code{\link{data.frame}} to be
coerced.}
}
\value{
A \linkS4class{CountMatrix} or an \linkS4class{IncidenceMatrix}.
}
\description{
Coerce
}
\details{
The following methods coerce a \code{matrix} or \code{data.frame} to a
 \code{*Matrix} object:

 \tabular{ll}{
  \strong{Method} \tab \strong{Target} \cr
  \code{as_count} \tab \linkS4class{CountMatrix} \cr
  \code{as_frequency} \tab \linkS4class{FrequencyMatrix} \cr
  \code{as_incidence} \tab \linkS4class{IncidenceMatrix} \cr
  \code{as_occurrence} \tab \linkS4class{OccurrenceMatrix} \cr
  \code{as_similarity} \tab \linkS4class{SimilarityMatrix}
 }
}
\examples{
## Create a count matrix
A1 <- CountMatrix(data = sample(0:10, 100, TRUE),
                  nrow = 10, ncol = 10)

## Coerce counts to frequencies
B <- as_frequency(A1)

## Row sums are internally stored before coercing to a frequency matrix
## (use totals() to get these values)
## This allows to restore the source data
A2 <- as_count(B)
all(A1 == A2)

## Coerce to presence/absence
C <- as_incidence(A1)

## Coerce to a co-occurrence matrix
D <- as_occurrence(A1)
}
\author{
N. Frerebeau
}
