% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setIDVar.R
\name{setIDVar}
\alias{setIDVar}
\title{Set an identifying variable}
\usage{
setIDVar(
  schema = NULL,
  name = NULL,
  value = NULL,
  columns = NULL,
  rows = NULL,
  split = NULL,
  merge = NULL,
  relative = FALSE,
  distinct = FALSE
)
}
\arguments{
\item{schema}{[\code{schema(1)}]\cr In case this information is added to an
already existing schema, provide that schema here (overwrites previous
information).}

\item{name}{[\code{character(1)}]\cr Name of the new identifying variable.}

\item{value}{[\code{character(1)}]\cr In case the variable is an implicit
variable (i.e., which is not in the origin table), specify it here.}

\item{columns}{[\code{integerish(.)}]\cr The column(s) in which the
\emph{values} of the new variable are recorded.}

\item{rows}{[\code{integerish(.)}]\cr In case the variable is in several
columns, specify here additionally the row in which the \emph{names} are
recorded.}

\item{split}{[\code{character(1)}]\cr In case the variable is part of a
compound value, this should be a regular expression that splits the
respective value off of that compound value. See
\code{\link[tidyr]{extract}} on how to set up the regular expression.}

\item{merge}{[\code{character(1)}]\cr In case a variable is made up of
several columns, this should be the character string that would connect the
two columns (e.g., an empty space \code{" "}).}

\item{relative}{[\code{logical(1)}]\cr whether the values provided in
\code{columns} and \code{rows} are relative to the cluster position(s) or
whether they refer to the overall table.}

\item{distinct}{[\code{logical(1)}]\cr whether or not the variable is
distinct from a cluster. This is the case when the variable is not
systematically available for all clusters and thus needs to be registered
separately from clusters.}
}
\value{
An object of class \code{\link{schema}}.
}
\description{
Identifying variables are those variables that describe the (qualitative)
properties that make each observation (as described by the
\code{\link[=setObsVar]{observed variables}}) unique.
}
\details{
Please also take a look at the currently suggested strategy to set
  up a \link[=schema]{schema description}.
}
\examples{
# please check the vignette for examples
}
\seealso{
Other functions to describe table arrangement: 
\code{\link{setCluster}()},
\code{\link{setFilter}()},
\code{\link{setFormat}()},
\code{\link{setGroups}()},
\code{\link{setObsVar}()}
}
\concept{functions to describe table arrangement}
