% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_methods.R
\name{tabr-head}
\alias{tabr-head}
\alias{head.noteworthy}
\alias{head.noteinfo}
\alias{head.music}
\alias{head.lyrics}
\alias{tail.noteworthy}
\alias{tail.noteinfo}
\alias{tail.music}
\alias{tail.lyrics}
\title{Head and tail for tabr classes}
\usage{
\method{head}{noteworthy}(x, ...)

\method{head}{noteinfo}(x, ...)

\method{head}{music}(x, ...)

\method{head}{lyrics}(x, ...)

\method{tail}{noteworthy}(x, ...)

\method{tail}{noteinfo}(x, ...)

\method{tail}{music}(x, ...)

\method{tail}{lyrics}(x, ...)
}
\arguments{
\item{x}{object.}

\item{...}{number of elements to return.}
}
\description{
Several methods are implemented for the classes \code{noteworthy}, \code{noteinfo}, and
\code{music}. See \code{\link[=tabr-methods]{tabr-methods()}} for more details on methods for tabr classes.
}
\examples{
# noteworthy class examples
x <- "a b c d e f g"
head(x, 2)
head(as_noteworthy(x), 2)
tail(as_noteworthy(x), 2)

# noteinfo class examples
x <- "4x 4-.*8 2 4"
head(as_noteinfo(x))
tail(as_noteinfo(x))

# music class examples
x <- "c,~4 c,1 c'e_'g'4-."
head(as_music(x), 2)
tail(as_music(x), 2)
}
\seealso{
\code{\link[=tabr-methods]{tabr-methods()}}, \code{\link[=note-metadata]{note-metadata()}}
}
