% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_gt.R
\name{as_gt}
\alias{as_gt}
\title{as_gt}
\usage{
as_gt(
  tbl,
  groupname_col = NULL,
  separator_style = gt::cell_borders(sides = c("right"), weight = gt::px(1), color =
    "gray"),
  auto_format = TRUE,
  ...
)
}
\arguments{
\item{tbl}{table created with tablespan::tablespan}

\item{groupname_col}{Provide column names to group data. See ?gt::gt for more
details.}

\item{separator_style}{style of the vertical line that separates the row names
from the data.}

\item{auto_format}{should the table be formatted automatically?}

\item{...}{additional arguments passed to gt::gt().}
}
\value{
gt table that can be further adapted with the gt package.
}
\description{
Translates a table created with tablespan to a great table (gt). See <https://gt.rstudio.com/>.
}
\details{
Tablespan itself does not provide any printing of tables as HTML table. However,
with as_gt, tablespan can be translated to a great table which provides html and
LaTeX output.
}
\examples{
library(tablespan)
library(dplyr)
data("mtcars")

summarized_table <- mtcars |>
  group_by(cyl, vs) |>
  summarise(N = n(),
            mean_hp = mean(hp),
            sd_hp = sd(hp),
            mean_wt = mean(wt),
            sd_wt = sd(wt))

tbl <- tablespan(data = summarized_table,
                 formula = (LHS = Cylinder:cyl + Engine:vs) ~
                   N +
                   (Results = (`Horse Power` = Mean:mean_hp + SD:sd_hp) +
                      (`Weight` = Mean:mean_wt + SD:sd_wt)))

gt_tbl <- as_gt(tbl)
gt_tbl
}
