% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/div_quantile.R
\name{div_quantile}
\alias{div_quantile}
\title{Split a Variable by Quantile Statistics}
\usage{
div_quantile(var, div, data)
}
\arguments{
\item{var}{A string. A variable to be summarized given as a string.}

\item{div}{A positive integer greater than 1. The number of factor levels when the variable is split by quantile statistics.}

\item{data}{A data frame in which these variables exist.}
}
\value{
A factor variable.
}
\description{
Split a continuous variable by quantile statistics, Converts a continuous variable to a categorical variable.
}
\examples{
## Load Mayo Clinic Primary Biliary Cirrhosis Data
library(survival)
library(tableeasy)
data(pbc)
## Check variables
head(pbc)
##
div_quantile(var = 'age', div = 5, data = pbc)
}
