% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableHTML2image.R
\name{tableHTML_to_image}
\alias{tableHTML_to_image}
\title{Convert a tableHTML into an image}
\usage{
tableHTML_to_image(
  tableHTML,
  file = NULL,
  type = c("png", "jpeg"),
  add = FALSE,
  selector = "table",
  ...
)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{file}{A file to write the image to. If NULL then file is just
displayed on screen.}

\item{type}{Either png or jpeg. The type of the image.}

\item{add}{Logical. If TRUE, the plot will be added to the existing plot.
If FALSE, the current device will be shut down.}

\item{selector}{One or more CSS selectors specifying a DOM element to set the
clipping rectangle to. The screenshot will contain these DOM elements. For
a given selector, if it has more than one match, only the first one will be
used. This option is not compatible with \code{cliprect}. When taking
screenshots of multiple URLs, this parameter can also be a list with same
length as \code{url} with each element of the list containing a vector of
CSS selectors to use for the corresponding URL.}

\item{...}{Parameters passed on to webshot. Check \code{\link[webshot]{webshot}}.}
}
\value{
An image of the tableHTML.
}
\description{
\code{tableHTML_to_image} converts the tableHTML into an image.
}
\details{
The main rational behind this function is to make it work well with pdfs / word documents.
When using rmarkdown and want to incude a tableHTML in a pdf / word document this is the
function you would need to use. Obviously, you don't need this function if you are exporting
to an html file.

Specifying a type will determine which function is used to create the image. Either
JPEG or PNG. When using JPEG as the type you will need to add a background
colour to the table otherwise it will be set to black by JPEG. Both of the
built-in themes (rshiny-blue, scientific) work well with JPEG.

When working on rmarkdown and you want to knit as pdf, use this function.
Works with microsoft word as well.

To use this function you need phantomjs installed. Please use \code{webshot::install_phantomjs()} 
to install if it is not installed already.
}
\examples{
\dontrun{
mtcars \%>\%
  tableHTML() \%>\%
  tableHTML_to_image()
}

}
