% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_header_css.R
\name{add_css_header}
\alias{add_css_header}
\title{Add css to tableHTML's headers}
\usage{
add_css_header(tableHTML, css, headers)
}
\arguments{
\item{tableHTML}{A tableHTML object created by the tableHTML function.}

\item{css}{A list of two elements with the corresponding css. The first element of the list
should be an atomic vector with the style definitions (e.g. background-color). The second
element will be an atomic vector with the same length as the first element, which will 
contain the style definitions' values (e.g. red). Check the examples for more information.}

\item{headers}{A numeric atomic vector with the indices of the headers where the style
definitions will be applied on. At least one header index must be provided.}
}
\value{
A tableHTML object.
}
\description{
\code{add_css_header} will add css to a tableHTML's headers
}
\details{
\code{add_css_header} will add css to a tableHTML's headers.
}
\examples{
tableHTML(mtcars) \%>\% 
  add_css_header(css = list(c('background-color', 'border'), c('lightgray', '3px solid green')),
                 headers = 2) 

tableHTML(mtcars) \%>\% 
  add_css_header(css = list(c('background-color', 'border'), c('lightgray', '3px solid green')), 
                 headers = c(1, 4))
}
