% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_tableHTML_family.R
\name{render_tableHTML}
\alias{render_tableHTML}
\title{Implementing tableHTML in shiny}
\usage{
render_tableHTML(expr, env = parent.frame(), quoted = FALSE, func = NULL)
}
\arguments{
\item{expr}{A tableHTML object.}

\item{env}{An environment.}

\item{quoted}{A boolean value. Whether the expression is quoted or not.}

\item{func}{Deprecated. Please use expr instead.}
}
\description{
This function is used to implement tableHTML in a shiny app. This function is used in the shiny
server.R file. Internally, it just calls renderUI, since tableHTML creates HTML code.
}
\examples{
\dontrun{

library(shiny)
shinyApp(
 ui = fluidPage(
  fluidRow(
  #leave some spacing
  br(),
  column(width = 1),
  tableHTML_output("mytable"))
 ), 
server = function(input, output) {
 output$mytable <- render_tableHTML( 
  tableHTML(mtcars)
 )}
)

}

}
\seealso{
\code{renderUI}
}

