% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bracket_helpers.R
\name{bracket_drop}
\alias{bracket_drop}
\alias{bracket_extract}
\alias{bracket_insert_left}
\alias{bracket_insert_right}
\alias{bracket_point_estimate}
\alias{bracket_lower_bound}
\alias{bracket_upper_bound}
\title{Bracket helpers}
\usage{
bracket_drop(x, bracket_left = "(", bracket_right = ")")

bracket_extract(
  x,
  bracket_left = "(",
  bracket_right = ")",
  drop_bracket = FALSE
)

bracket_insert_left(x, string, bracket_left = "(", bracket_right = ")")

bracket_insert_right(x, string, bracket_left = "(", bracket_right = ")")

bracket_point_estimate(x, bracket_left = "(", bracket_right = ")")

bracket_lower_bound(
  x,
  bracket_left = "(",
  separator = ",",
  bracket_right = ")"
)

bracket_upper_bound(
  x,
  bracket_left = "(",
  separator = ",",
  bracket_right = ")"
)
}
\arguments{
\item{x}{a character vector where each value contains a point
estimate and confidence limits.}

\item{bracket_left}{a character value specifying what symbol is
used to bracket the left hand side of the confidence interval}

\item{bracket_right}{a character value specifying what symbol is
used to bracket the right hand side of the confidence interval}

\item{drop_bracket}{a logical value (\code{TRUE} or \code{FALSE}). If \code{TRUE},
then the symbols on the left and right hand side of the interval
will not be included in the returned value. If \code{FALSE}, these symbols
will be included.}

\item{string}{a character value of a string that will be inserted
into the left or right side of the bracket.}

\item{separator}{a character value specifying what symbol is used
to separate the lower and upper bounds of the interval.}
}
\value{
a character value with length equal to the length of \code{x}.
}
\description{
If you have table values that take the form
\emph{point estimate (uncertainty estimate)}, you can use these
functions to access specific parts of the table value.
}
\examples{

tbl_value <- "12.1 (95\% CI: 9.1, 15.1)"
bracket_drop(tbl_value)
bracket_point_estimate(tbl_value)
bracket_extract(tbl_value, drop_bracket = TRUE)
bracket_lower_bound(tbl_value)
bracket_upper_bound(tbl_value)

}
