% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/round_spec.R
\name{format_big}
\alias{format_big}
\title{Format values left of decimal}
\usage{
format_big(rspec, mark = ",", interval = 3L)
}
\arguments{
\item{rspec}{a \code{rounding_specification} object (see \link{round_spec}).}

\item{mark}{a character value used to separate number groups to the
left of the decimal point. See \link{prettyNum} for more details on this.
Set this input to '' to negate it's effect.}

\item{interval}{a numeric value indicating the size of number groups
for numbers left of the decimal.}
}
\value{
an object of class \code{rounding_specification}.
}
\description{
Values to the left of the decimal are generally called 'big' since they
are larger than values to the right of the decimal. \code{format_big()}
lets you update the settings of a \code{rounding_specification} object
(see \link{round_spec}) so that values left of the decimal will be printed
with a specific format (see examples).
}
\examples{

big_x <- 1234567

rspec <- format_big(round_spec(), mark = '|', interval = 3)

table_value(big_x, rspec) # returns "1|234|567"

}
\concept{format helpers}
