% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-where.R
\name{where-table.express}
\alias{where-table.express}
\alias{where}
\alias{where.ExprBuilder}
\alias{where.data.table}
\title{Where clause}
\usage{
where(.data, ...)

\method{where}{ExprBuilder}(
  .data,
  ...,
  which,
  .collapse = `&`,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE)
)

\method{where}{data.table}(.data, ...)
}
\arguments{
\item{.data}{The input data.}

\item{...}{Arguments for the specific methods.}

\item{which}{Passed to \link[data.table:data.table]{data.table::data.table}.}

\item{.collapse}{A boolean function which will be used to "concatenate" all conditions in \code{...}.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Clause for subsetting rows.
}
\details{
For \link{ExprBuilder}, the expressions in \code{...} can call \code{\link[=nest_expr]{nest_expr()}}, and are eagerly nested if
they do.

The \link[data.table:data.table-class]{data.table::data.table} method is \strong{lazy}, so it expects another verb to follow
\emph{afterwards}.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    where(vs == 0, am == 1)


data.table::as.data.table(mtcars) \%>\%
    where(vs == 0) \%>\%
    transmute(mpg = round(mpg))

}
