% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UTILS-nest_expr.R
\name{nest_expr}
\alias{nest_expr}
\title{Nest expressions as a functional chain}
\usage{
nest_expr(..., .start = TRUE, .end = .start,
  .parse = getOption("table.express.parse", FALSE))
}
\arguments{
\item{...}{Expressions that will be part of the functional chain.}

\item{.start}{Whether to add a \code{\link[=start_expr]{start_expr()}} call at the beginning of the chain.}

\item{.end}{Whether to add an \code{\link[=end_expr]{end_expr()}} call at the end of the chain.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}
}
\description{
Nest expressions as a functional chain
}
\details{
All expressions in \code{...} are "collapsed" with \code{\link[magrittr:pipe]{\%>\%}}, passing the
\link{ExprBuilder}'s captured \code{data.table} as the initial parameter. Names are silently dropped.

The chain is evaluated eagerly and saved in the \code{ExprBuilder} instance to be used during final
expression evaluation.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
