% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadIsotopeData.R
\name{loadIsotopeData}
\alias{loadIsotopeData}
\title{Extract and load stable isotope data for selected consumers from a data frame}
\usage{
loadIsotopeData(
  df = NULL,
  consumer = NULL,
  group = NULL,
  b1 = "Baseline 1",
  b2 = NULL,
  baselineColumn = "FG",
  consumersColumn = "FG",
  groupsColumn = NULL,
  d13C = "d13C",
  d15N = "d15N",
  deltaC = NULL,
  deltaN = NULL,
  seed = 666,
  ...
)
}
\arguments{
\item{df}{data frame containing raw isotope data with at least one grouping
column.}

\item{consumer}{string or character vector indicating which consumer/species
will be extracted.}

\item{group}{string or character vector indicating which group(s)
will be extracted.}

\item{b1}{string or character vector indicating which baseline(s) will be
extracted as baseline 1.}

\item{b2}{string or character vector indicating which baseline(s) will be
extracted as baseline 2.}

\item{baselineColumn}{string of the column where baselines are grouped.}

\item{consumersColumn}{string of the column where species/consumer(s) are
grouped.}

\item{groupsColumn}{string of the column where groups/communities are
grouped.}

\item{d13C}{string indicating from which column extract d13C isotope values.}

\item{d15N}{string indicating from which column extract d15N isotope values.}

\item{deltaC}{vector of values with trophic discrimination factor for carbon.
If NULL it will use Post's assumptions (56 values with 3.4 mean +- 0.98
sd).}

\item{deltaN}{vector of values with trophic discrimination factor for
nitrogen. If NULL it will use Post's assumptions (107 values with 0.39 mean
+- 1.3 sd).}

\item{seed}{numerical value to get reproducible results with trophic
discrimination factors (because they are simulated each time this function
is called). By default, is 3.}

\item{...}{Additional arguments passed to this function.}
}
\value{
an isotopeData class object if one consumer and one group are
  selected. A list of isotopeData class objects if more than one consumer or
  more than one group are selected.
}
\description{
This function extracts only selected consumers/species with their respective
baseline(s) and returns an isotopeData class object (or list). It is useful
when there are a lot of information in a data frame and you want to calculate
trophic position only for selected consumers in one or more communities.
}
\examples{
data("Bilagay")
head(Bilagay)
loadIsotopeData(df = Bilagay, consumer = "Bilagay", consumersColumn = "FG",
group = c("CHI", "COL"), groupsColumn = "Location",
b1 = "Benthic_BL", b2 = "Pelagic_BL", baselineColumn = "FG")
}
