% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.user.collection.R
\name{trakt.user.collection}
\alias{trakt.user.collection}
\title{Get a user's collected shows or movies}
\usage{
trakt.user.collection(user = getOption("trakt.username"), type = "shows")
}
\arguments{
\item{user}{Target user. Defaults to \code{getOption("trakt.username")}}

\item{type}{Either \code{shows} (default) or \code{movies}}
}
\value{
A \code{data.frame} containing stats
}
\description{
\code{trakt.user.collection} pulls a user's watched shows or movies.
It does not use OAuth2, so you can only get data for a user with a
public profile.
}
\note{
See \href{http://docs.trakt.apiary.io/reference/users/collection/get-collection}{the trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
myshows      <- trakt.user.collection() # Defaults to your username if set
seans.movies <- trakt.user.collection(user = "sean", type = "movies)
}
}
\seealso{
Other user: \code{\link{trakt.user.followers}};
  \code{\link{trakt.user.following}};
  \code{\link{trakt.user.friends}};
  \code{\link{trakt.user.ratings}};
  \code{\link{trakt.user.stats}};
  \code{\link{trakt.user.watched}};
  \code{\link{trakt.user.watchlist}}
}

