% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.getFullShowData.R
\name{trakt.getFullShowData}
\alias{trakt.getFullShowData}
\title{Get all the show data}
\usage{
trakt.getFullShowData(query = NULL, slug = NULL, dropunaired = TRUE)
}
\arguments{
\item{query}{Keyword used for \link{trakt.search}. Optional.}

\item{slug}{Used if \code{query} is not specified. Optional, but gives exact results.}

\item{dropunaired}{If \code{TRUE}, episodes which have not aired yet are dropped.}
}
\value{
A \code{list} containing multiple \code{lists} and \code{data.frames} with show info.
}
\description{
\code{trakt.getFullShowData} is a combination function of multiple
functions in this package. The idea is to easily execute all major functions
required to get a full show dataset.
}
\note{
This is primarily intended to be a convenience function for the case where you
really want all that data. If you're just derping around, maybe you should consider interactively
calling the other functions.
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
# Use the search within the function
breakingbad <- trakt.getFullShowData("Breaking Bad")
# Alternatively, us a slug for explicit results
breakingbad <- trakt.getFullShowData(slug = "breaking-bad")
}
}
\seealso{
Other show: \code{\link{trakt.getEpisodeData}};
  \code{\link{trakt.getSeasons}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.related}};
  \code{\link{trakt.show.season}};
  \code{\link{trakt.show.stats}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.trending}}
}

