% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pull_population.R
\name{pull_population}
\alias{pull_population}
\title{Pull ACS population data}
\usage{
pull_population(endyear, span, geography)
}
\arguments{
\item{endyear}{An integer, indicating the latest year of the data in the survey.}

\item{span}{An integer in \code{c(1,3,5)} indicating the span of the desired data.}

\item{geography}{a valid \code{geo.set} object specifying the census geography or 
geographies to be fetched.}
}
\value{
A \code{list} containing the endyear, span, a \code{data.frame} of estimates,
a \code{data.frame} of standard errors, a character vector of the original column names,
and a \code{data.frame} of the geography metadata from \code{\link[acs]{acs.fetch}}.
}
\description{
Pull ACS data for a specified geography from base tables
B01001, B01002, B02001, B06007, B06008, B06009, B06010, B06011, AND B06012.
These tables reference population counts by a number of slices.
Multiple additional fields, mainly percentages and aggregations, are calculated.
}
\seealso{
\code{\link[acs]{acs.fetch}}, \code{\link[acs]{geo.make}}
}

