% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_participant.R
\name{create_participant}
\alias{create_participant}
\title{Create a Participant instance.}
\usage{
create_participant(
  participant_id,
  grapheme_symbols,
  n_trials_per_grapheme,
  trial_symbols,
  response_times = NULL,
  response_colors,
  color_space_spec = "Luv",
  test_date = NULL
)
}
\arguments{
\item{participant_id}{A one-element character vector holding a participant id.}

\item{grapheme_symbols}{A character vector of symbols/graphemes for which
Grapheme instances should be created and linked to the Participant instance.}

\item{n_trials_per_grapheme}{A one-element numeric vector holding the number
of trials per grapheme.}

\item{trial_symbols}{A character vector that holds one symbol/grapheme
for each trial of the participant's consistency test run.}

\item{response_times}{(optional) A numeric vector. Consistency test times from
presentation to response, in order.}

\item{response_colors}{A character vector. Consistency test response
colors, as hex color codes.}

\item{color_space_spec}{A one-element character vector. What color
space is to be used? The following color spaces are supported:
"XYZ", "sRGB", "Apple RGB", "Lab", and "Luv"}

\item{test_date}{(optional) A one-element character vector in the format
"YYYY-MM-DD" that indicates on what date the participant
finished the consistency test.}
}
\description{
Takes in a participant id, set of symbols for which graphemes
should be created and participant trial/response data. Returns a Participant
instance with all the input data linked to it. For each grapheme, if there
are data for less trials than the number specified by n_trials_per_grapheme,
NA values are added to affected graphemes' associated vectors of response
times/colors.
}
\examples{
participant_id <- "1"
target_symbols_vec <- c("A", "D", "7")
symbol_vec <- c("A", "D", "7",
                "D", "A", "7",
                "7", "A", "D")
times_vec <- c(1.1, 0.4, 5,
               0.3, 2.4, 7.3,
               1, 10.2, 8.4)
color_vec <- c("98FF22", "138831", "791322",
               "8952FE", "DC8481", "7D89B0",
               "001100", "887755", "FF0033")
p <- create_participant(participant_id=participant_id,
                        grapheme_symbols=target_symbols_vec,
                        n_trials_per_grapheme=3,
                        trial_symbols=symbol_vec,
                        response_times=times_vec,
                        response_colors=color_vec,
                        color_space_spec="Luv")
}
