/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import haplotype.BasicSampleHapPairs;
import haplotype.HapPair;
import haplotype.SampleHapPairs;
import haplotype.Weights;
import java.util.List;
import main.GeneticMap;
import main.NuclearFamilies;
import main.Par;
import vcf.Data;
import vcf.GL;
import vcf.Markers;
import vcf.SplicedGL;

public class CurrentData {
    private static final float MIN_GEN_DIST = 1.0E-7f;
    private final int window;
    private final SampleHapPairs initHaps;
    private final int prevSpliceStart;
    private final int nextOverlapStart;
    private final int nextSpliceStart;
    private final int nextTargetSpliceStart;
    private final int nextTargetOverlapStart;
    private final GL targetGL;
    private final NuclearFamilies families;
    private final Weights weights;
    private final Samples refSamples;
    private final Samples targetSamples;
    private final Samples allSamples;
    private final Markers markers;
    private final Markers targetMarkers;
    private final int[] targetMarkerIndex;
    private final int[] markerIndex;
    private final List<HapPair> restRefHapPairs;
    private final SampleHapPairs refSampleHapPairs;
    private final SampleHapPairs restrictedRefSampleHapPairs;
    private final float[] recombRate;

    public CurrentData(Par par, GeneticMap geneticMap, Data data, SampleHapPairs sampleHapPairs, NuclearFamilies nuclearFamilies) {
        if (!nuclearFamilies.samples().equals(data.targetSamples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        if (sampleHapPairs != null && !data.targetSamples().equals(sampleHapPairs.samples())) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        this.window = data.window();
        this.initHaps = sampleHapPairs;
        this.prevSpliceStart = data.overlap() / 2;
        this.nextOverlapStart = CurrentData.nextOverlapStart(data, par.overlap());
        this.nextSpliceStart = (data.nMarkers() + this.nextOverlapStart) / 2;
        this.nextTargetOverlapStart = CurrentData.targetIndex(data, this.nextOverlapStart);
        this.nextTargetSpliceStart = CurrentData.targetIndex(data, this.nextSpliceStart);
        this.families = nuclearFamilies;
        this.weights = new Weights(nuclearFamilies);
        this.targetGL = sampleHapPairs == null ? data.targetGL() : new SplicedGL(sampleHapPairs, data.targetGL());
        this.refSamples = data.refSamples();
        this.targetSamples = data.targetSamples();
        this.allSamples = data.allSamples();
        this.markers = data.markers();
        this.targetMarkers = data.targetMarkers();
        this.targetMarkerIndex = this.refToTargetMarker(data);
        this.markerIndex = CurrentData.targetToRefMarker(data);
        this.restRefHapPairs = data.restrictedRefHapPairs();
        this.refSampleHapPairs = data.refSampleHapPairs();
        this.restrictedRefSampleHapPairs = this.refSamples != null ? new BasicSampleHapPairs(this.refSamples, this.restRefHapPairs) : null;
        this.recombRate = CurrentData.recombRate(this.targetMarkers, geneticMap, par.mapscale());
    }

    private static int nextOverlapStart(Data data, int n) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n == 0 || data.lastWindowOnChrom()) {
            return data.nMarkers();
        }
        Markers markers = data.markers();
        for (n2 = Math.max(0, data.nMarkers() - n); n2 > 0 && markers.marker(n2).pos() == markers.marker(n2 - 1).pos(); --n2) {
        }
        return n2;
    }

    private static int nextSpliceStart(Data data, int n) {
        if (data.canAdvanceWindow() && !data.lastWindowOnChrom()) {
            return data.nMarkers() - n + n / 2;
        }
        return data.nMarkers();
    }

    private static int targetIndex(Data data, int n) {
        int n2;
        for (n2 = 0; n2 < data.nTargetMarkers() && data.markerIndex(n2) < n; ++n2) {
        }
        return n2;
    }

    private static float[] recombRate(Markers markers, GeneticMap geneticMap, float f) {
        if (geneticMap == null) {
            return null;
        }
        double d = -2.0 * (double)f;
        float[] fArray = new float[markers.nMarkers()];
        fArray[0] = 0.0f;
        double d2 = geneticMap.genPos(markers.marker(0));
        for (int i = 1; i < fArray.length; ++i) {
            double d3 = geneticMap.genPos(markers.marker(i));
            double d4 = Math.max(Math.abs(d3 - d2), (double)1.0E-7f);
            fArray[i] = (float)(-Math.expm1(d * d4));
            d2 = d3;
        }
        return fArray;
    }

    public int window() {
        return this.window;
    }

    public int nextOverlapStart() {
        return this.nextOverlapStart;
    }

    public int nextTargetOverlapStart() {
        return this.nextTargetOverlapStart;
    }

    public int prevSpliceStart() {
        return this.prevSpliceStart;
    }

    public int nextSpliceStart() {
        return this.nextSpliceStart;
    }

    public int prevTargetSpliceStart() {
        return this.initHaps == null ? 0 : this.initHaps.nMarkers();
    }

    public int nextTargetSpliceStart() {
        return this.nextTargetSpliceStart;
    }

    public SampleHapPairs initHaps() {
        return this.initHaps;
    }

    private int[] refToTargetMarker(Data data) {
        int[] nArray = new int[data.nMarkers()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = data.targetMarkerIndex(i);
        }
        return nArray;
    }

    private static int[] targetToRefMarker(Data data) {
        int[] nArray = new int[data.nTargetMarkers()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = data.markerIndex(i);
        }
        return nArray;
    }

    public NuclearFamilies families() {
        return this.families;
    }

    public Weights weights() {
        return this.weights;
    }

    public int nRefSamples() {
        return this.refSamples == null ? 0 : this.refSamples.nSamples();
    }

    public Samples refSamples() {
        return this.refSamples;
    }

    public int nTargetSamples() {
        return this.targetSamples.nSamples();
    }

    public Samples targetSamples() {
        return this.targetSamples;
    }

    public int nAllSamples() {
        return this.allSamples.nSamples();
    }

    public Samples allSamples() {
        return this.allSamples;
    }

    public int nTargetMarkers() {
        return this.targetMarkers.nMarkers();
    }

    public Markers targetMarkers() {
        return this.targetMarkers;
    }

    public int nMarkers() {
        return this.markers.nMarkers();
    }

    public Markers markers() {
        return this.markers;
    }

    public int markerIndex(int n) {
        return this.markerIndex[n];
    }

    public int[] markerIndices() {
        return (int[])this.markerIndex.clone();
    }

    public int targetMarkerIndex(int n) {
        return this.targetMarkerIndex[n];
    }

    public int[] targetMarkerIndices() {
        return (int[])this.targetMarkerIndex.clone();
    }

    public void addRestrictedRefHapPairs(List<HapPair> list) {
        list.addAll(this.restRefHapPairs);
    }

    public SampleHapPairs restrictedRefSampleHapPairs() {
        return this.restrictedRefSampleHapPairs;
    }

    public SampleHapPairs refSampleHapPairs() {
        return this.refSampleHapPairs;
    }

    public GL targetGL() {
        return this.targetGL;
    }

    public float[] recombRate() {
        return this.recombRate == null ? null : (float[])this.recombRate.clone();
    }
}

