/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import main.NuclearFamilies;
import vcf.BitSetGT;
import vcf.Marker;
import vcf.MedMemGL;
import vcf.VcfEmission;
import vcf.VcfRecord;

public final class MedMemGTGL
implements VcfEmission {
    private final Samples samples;
    private final Marker marker;
    private final VcfEmission gtData;
    private final VcfEmission glData;
    private final boolean preferGL;

    public MedMemGTGL(VcfRecord vcfRecord, NuclearFamilies nuclearFamilies, boolean bl, float f, boolean bl2) {
        boolean bl3 = vcfRecord.hasFormat("GT");
        boolean bl4 = vcfRecord.hasFormat("GL");
        boolean bl5 = vcfRecord.hasFormat("PL");
        if (!(bl3 || bl4 || bl5)) {
            String string = "missing GT FORMAT and GL/PL FORMAT: " + vcfRecord;
            throw new IllegalArgumentException(string);
        }
        this.samples = vcfRecord.samples();
        this.marker = vcfRecord.marker();
        this.gtData = bl3 ? new BitSetGT(vcfRecord, nuclearFamilies, bl) : null;
        this.glData = bl4 || bl5 ? new MedMemGL(vcfRecord, nuclearFamilies, f) : null;
        this.preferGL = bl2;
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Marker marker() {
        return this.marker;
    }

    @Override
    public boolean isRefData() {
        return this.gtData != null && (this.glData == null || !this.preferGL) ? this.gtData.isRefData() : this.glData.isRefData();
    }

    @Override
    public boolean isMissingData() {
        return this.gtData != null && (this.glData == null || !this.preferGL) ? this.gtData.isMissingData() : this.glData.isMissingData();
    }

    @Override
    public boolean isPhased(int n) {
        return this.gtData != null && (this.glData == null || !this.preferGL) ? this.gtData.isPhased(n) : false;
    }

    @Override
    public byte allele1(int n) {
        return this.gtData != null && (this.glData == null || !this.preferGL) ? this.gtData.allele1(n) : (byte)-1;
    }

    @Override
    public byte allele2(int n) {
        return this.gtData != null && (this.glData == null || !this.preferGL) ? this.gtData.allele2(n) : (byte)-1;
    }

    @Override
    public float gl(int n, byte by, byte by2) {
        if (this.gtData == null) {
            return this.glData.gl(n, by, by2);
        }
        if (this.glData == null) {
            return this.gtData.gl(n, by, by2);
        }
        if (this.preferGL) {
            return this.glData.gl(n, by, by2);
        }
        return this.gtData.gl(n, by, by2);
    }

    @Override
    public String toString() {
        if (this.gtData == null) {
            return this.glData.toString();
        }
        if (this.glData == null) {
            return this.gtData.toString();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.marker);
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("PASS");
        stringBuilder.append('\t');
        stringBuilder.append('.');
        stringBuilder.append('\t');
        stringBuilder.append("GT");
        stringBuilder.append(':');
        stringBuilder.append("GL");
        int n = this.samples.nSamples();
        for (int i = 0; i < n; ++i) {
            stringBuilder.append('\t');
            byte by = this.allele1(i);
            byte by2 = this.allele2(i);
            if (by >= 0 && by2 >= 0) {
                stringBuilder.append(by);
                stringBuilder.append(this.gtData.isPhased(i) ? (char)'|' : '/');
                stringBuilder.append(by2);
                continue;
            }
            stringBuilder.append('.');
            stringBuilder.append('/');
            stringBuilder.append('.');
            int n2 = this.marker.nAlleles();
            for (by2 = 0; by2 < n2; by2 = (byte)(by2 + 1)) {
                for (by = 0; by <= by2; by = (byte)(by + 1)) {
                    stringBuilder.append((char)(by == 0 && by2 == 0 ? 58 : 44));
                    double d = Math.log10(this.gl(i, by, by2));
                    stringBuilder.append(MedMemGL.df.format(d));
                }
            }
        }
        return stringBuilder.toString();
    }
}

