/*
 * Decompiled with CFR 0.152.
 */
package sample;

import dag.Dag;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import sample.HapBaumLevel;
import sample.HapNodes;
import vcf.AL;

public class HapBaum {
    private final Dag dag;
    private final AL al;
    private final int nMarkers;
    private final int nCopies;
    private final long seed;
    private final Random random;
    private final int[] node;
    private final double[] nodeValue;
    private final byte[][] alleles1;
    private final byte[][] alleles2;
    private final double[] alProbs1;
    private final double[] alProbs2;
    private final HapBaumLevel[] levels;
    private final HapNodes fwdNodes;
    private final HapNodes bwdNodes;
    private int windowIndex = -9999;
    private int arrayIndex = -9999;

    public HapBaum(Dag dag, AL aL, long l, int n) {
        if (!dag.markers().equals(aL.markers())) {
            throw new IllegalArgumentException("inconsistent markers");
        }
        if (n < 1) {
            throw new IllegalArgumentException("nCopies<1: " + n);
        }
        this.dag = dag;
        this.al = aL;
        this.nMarkers = dag.nMarkers();
        this.nCopies = n;
        this.seed = l;
        this.random = new Random(l);
        this.node = new int[n];
        this.nodeValue = new double[n];
        this.alleles1 = new byte[n][aL.nMarkers()];
        this.alleles2 = new byte[n][aL.nMarkers()];
        this.alProbs1 = new double[aL.markers().sumAlleles()];
        this.alProbs2 = new double[aL.markers().sumAlleles()];
        int n2 = (int)Math.ceil(Math.sqrt(1 + 8 * dag.nMarkers()) / 2.0) + 1;
        this.levels = new HapBaumLevel[n2];
        for (int i = 0; i < this.levels.length; ++i) {
            this.levels[i] = new HapBaumLevel(dag, aL);
        }
        this.fwdNodes = new HapNodes();
        this.bwdNodes = new HapNodes();
    }

    public Dag dag() {
        return this.dag;
    }

    public AL al() {
        return this.al;
    }

    public int nCopies() {
        return this.nCopies;
    }

    public long seed() {
        return this.seed;
    }

    public List<HapPair> randomSample(int n) {
        int n2 = 2 * n;
        this.randomSample(n2, this.alleles1);
        this.randomSample(++n2, this.alleles2);
        return this.hapList(n);
    }

    private void randomSample(int n, byte[][] byArray) {
        this.forwardAlgorithm(n);
        this.initSampleAlleles(this.currentLevel(), n, byArray);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            HapBaumLevel hapBaumLevel = this.previousLevel(n);
            this.sampleAlleles(hapBaumLevel, n, byArray);
        }
    }

    public List<HapPair> randomSample(int n, double[] dArray) {
        this.checkGprobs(dArray);
        int n2 = 2 * n;
        this.randomSample(n2, this.alleles1, this.alProbs1);
        this.randomSample(++n2, this.alleles2, this.alProbs2);
        this.setGprobs(dArray);
        return this.hapList(n);
    }

    private void checkGprobs(double[] dArray) {
        if (dArray.length != this.al.markers().sumGenotypes()) {
            String string = "gtProbs.length!=al.markers().sumGenotypes()";
            throw new IllegalArgumentException(string);
        }
    }

    private void randomSample(int n, byte[][] byArray, double[] dArray) {
        this.forwardAlgorithm(n);
        this.initSampleAlleles(this.currentLevel(), n, byArray);
        this.currentLevel().setInitialBackwardValues(this.bwdNodes);
        this.setAlProbs(this.currentLevel(), dArray);
        for (int i = this.nMarkers - 2; i >= 0; --i) {
            HapBaumLevel hapBaumLevel = this.previousLevel(n);
            this.sampleAlleles(hapBaumLevel, n, byArray);
            hapBaumLevel.setBackwardValues(this.bwdNodes);
            this.setAlProbs(hapBaumLevel, dArray);
        }
    }

    private void setGprobs(double[] dArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.nMarkers; ++i) {
            int n3 = n2;
            n2 = this.al.markers().sumAlleles(i + 1);
            for (int j = n3; j < n2; ++j) {
                for (int k = n3; k < j; ++k) {
                    dArray[n++] = this.alProbs1[k] * this.alProbs2[j] + this.alProbs1[j] * this.alProbs2[k];
                }
                dArray[n++] = this.alProbs1[j] * this.alProbs2[j];
            }
        }
        assert (n == dArray.length);
    }

    private void setAlProbs(HapBaumLevel hapBaumLevel, double[] dArray) {
        if (dArray != null) {
            int n = hapBaumLevel.marker();
            int n2 = this.al.marker(n).nAlleles();
            int n3 = this.al.markers().sumAlleles(n);
            for (int i = 0; i < n2; ++i) {
                dArray[n3 + i] = hapBaumLevel.alProbs(i);
            }
        }
    }

    private List<HapPair> hapList(int n) {
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(2 * this.nCopies);
        for (int i = 0; i < this.nCopies; ++i) {
            BitHapPair bitHapPair = new BitHapPair(this.al.markers(), this.al.samples().idIndex(n), this.alleles1[i], this.alleles2[i]);
            arrayList.add(bitHapPair);
        }
        return arrayList;
    }

    private void initSampleAlleles(HapBaumLevel hapBaumLevel, int n, byte[][] byArray) {
        int n2 = hapBaumLevel.marker();
        for (int i = 0; i < this.nCopies; ++i) {
            int n3 = this.initialRandomState(hapBaumLevel);
            this.node[i] = hapBaumLevel.parentNode(n3);
            this.nodeValue[i] = this.parentSum(hapBaumLevel, n, n3);
            byArray[i][n2] = hapBaumLevel.symbol(n3);
        }
    }

    private int initialRandomState(HapBaumLevel hapBaumLevel) {
        double d = this.random.nextDouble();
        double d2 = 0.0;
        int n = hapBaumLevel.size();
        for (int i = 0; i < n; ++i) {
            if (!(d <= (d2 += hapBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        assert (false);
        return hapBaumLevel.size() - 1;
    }

    private double parentSum(HapBaumLevel hapBaumLevel, int n, int n2) {
        int n3 = hapBaumLevel.marker();
        double d = hapBaumLevel.forwardValuesSum() * hapBaumLevel.forwardValue(n2);
        int n4 = hapBaumLevel.edge(n2);
        double d2 = this.dag.condEdgeProb(n3, n4);
        byte by = this.dag.symbol(n3, n4);
        double d3 = this.al.al(n3, n, by);
        return d / (d3 * d2);
    }

    private void sampleAlleles(HapBaumLevel hapBaumLevel, int n, byte[][] byArray) {
        int n2 = hapBaumLevel.marker();
        for (int i = 0; i < this.nCopies; ++i) {
            int n3 = this.randomPreviousState(hapBaumLevel, this.node[i], this.nodeValue[i]);
            this.node[i] = hapBaumLevel.parentNode(n3);
            this.nodeValue[i] = this.parentSum(hapBaumLevel, n, n3);
            byArray[i][n2] = hapBaumLevel.symbol(n3);
        }
    }

    private int randomPreviousState(HapBaumLevel hapBaumLevel, int n, double d) {
        double d2 = this.random.nextDouble() * d;
        double d3 = 0.0;
        int n2 = hapBaumLevel.size();
        for (int i = 0; i < n2; ++i) {
            if (n != hapBaumLevel.childNode(i) || !(d2 <= (d3 += hapBaumLevel.forwardValue(i)))) continue;
            return i;
        }
        return hapBaumLevel.size() - 1;
    }

    private HapBaumLevel nextLevel() {
        ++this.arrayIndex;
        if (this.arrayIndex == this.levels.length) {
            ++this.windowIndex;
            this.arrayIndex = this.windowIndex;
        }
        return this.levels[this.arrayIndex];
    }

    private HapBaumLevel currentLevel() {
        return this.levels[this.arrayIndex];
    }

    private HapBaumLevel previousLevel(int n) {
        if (this.arrayIndex == this.windowIndex) {
            --this.windowIndex;
            this.arrayIndex = this.windowIndex;
            this.levels[this.arrayIndex].setChildNodes(this.fwdNodes);
            int n2 = this.levels[this.windowIndex].marker() + 1;
            int n3 = n2 + (this.levels.length - (this.windowIndex + 1));
            for (int i = n2; i < n3; ++i) {
                this.nextLevel().setForwardValues(this.fwdNodes, i, n);
            }
            return this.currentLevel();
        }
        return this.levels[--this.arrayIndex];
    }

    private void forwardAlgorithm(int n) {
        HapBaumLevel.initializeNodes(this.fwdNodes);
        this.windowIndex = -1;
        this.arrayIndex = this.levels.length - 1;
        for (int i = 0; i < this.nMarkers; ++i) {
            this.nextLevel().setForwardValues(this.fwdNodes, i, n);
        }
    }
}

