% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_license.R
\name{add_license}
\alias{add_license}
\title{Add a LICENSE.txt file to your course}
\usage{
add_license(author, year = format(Sys.Date(), "\%Y"),
  open_source_content = TRUE, content_license = "CC BY 4.0",
  open_source_data = TRUE, data_license = "CC0", open_source_code = TRUE,
  code_license = "MIT")
}
\arguments{
\item{author}{The author of the course. This can be an organization.}

\item{year}{The year the course was written.}

\item{open_source_content}{If \code{TRUE} a Creative Commons content license
will be included pertaining to the content of your course.}

\item{content_license}{Specify which Creative Commons license you would like
to use for the content of your course. This must be equal to one of the
following: \code{"CC BY 4.0"}, \code{"CC BY-SA 4.0"}, \code{"CC BY-ND 4.0"},
\code{"CC BY-NC 4.0"}, \code{"CC BY-NC-SA 4.0"}, \code{"CC BY-NC-ND 4.0"},
or \code{"CC0"}.}

\item{open_source_data}{If \code{TRUE} a Creative Commons content license
will be included pertaining to the data distributed with your course.}

\item{data_license}{Currently this value must be equal to \code{"CC0"}, but
in the future it may be able to be other values.}

\item{open_source_code}{If \code{TRUE} a free software license
will be included pertaining to the software included in your course.}

\item{code_license}{Specify which open source software license you would like
to use for the content of your course. This must be equal to one of the
following: \code{"MIT"}, \code{"GPL3"}, \code{"CC0"}.}
}
\description{
Licensing your course is important if you want to share your course. For more
information see \url{https://github.com/swirldev/swirlify/wiki/Licensing-Your-Course}.
For more information about Creative Commons licenses see \url{http://creativecommons.org/licenses/}.
For more information about software licenses see \url{http://www.gnu.org/licenses/license-list.en.html}.
}
\examples{
\dontrun{

# Add a license with simple open source options
add_license("Team swirl")

# Add a license so that derivative works are shared alike
add_license("Team swirl", content_license  = "CC BY-SA 4.0", code_license ="GPL3")

# Add a license that reserves all of the author's rights
add_license("Team Bizzaro swirl", open_source_content = FALSE,
                                  open_source_data = FALSE,
                                  open_source_code = FALSE)
}
}
