% Generated by roxygen2 (4.0.2): do not edit by hand
\name{uniform.test}
\alias{uniform.test}
\title{Uniform Distribution Test}
\usage{
uniform.test(hist.output, B = NULL)
}
\arguments{
\item{hist.output}{output from a call to \code{hist}.}

\item{B}{number of replicates for chi-squared permutation.}
}
\value{
result of chi-squared test.
}
\description{
Tests whether a histogram is significantly different from a uniform distribution.
}
\examples{
x.unif <- runif(100)
uniform.test(hist(x.unif), B = 1000)
x.lnorm <- rlnorm(100)
uniform.test(hist(x.lnorm), B = 1000)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

