% Generated by roxygen2 (4.0.1): do not edit by hand
\name{oin_ctrl}
\alias{oin_ctrl}
\title{Check the control numbers for \code{oin}}
\usage{
oin_ctrl(oin)
}
\arguments{
\item{oin}{Vector with swedish organization identity numbers (oin) in \code{NNNNNN-NNNN} format.}
}
\value{
Logical vector indicating if a oin is correct (\code{TRUE}) or not (\code{FALSE})
}
\description{
Calculates the control number using the Luhn algorithm and compare it with the control number in the organization identity number (oin).
}
\examples{
ex_oin <- c("556000-4615", "232100-0156", "802002-4280", "232100-0157", "802002-4281")
oin_ctrl(ex_oin)
}
\references{
\href{http://www.skatteverket.se/download/18.70ac421612e2a997f85800040284/1302507382017/70909.pdf}{SKV 709}
}

