% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swdpower.R
\name{swdpower}
\alias{swdpower}
\title{A function of power calculation for Stepped Wedge Design Studies}
\usage{
swdpower(
  K,
  design,
  family = "binomial",
  model = "conditional",
  link = "identity",
  type = "cross-sectional",
  meanresponse_start = NA,
  meanresponse_end0 = meanresponse_start,
  meanresponse_end1 = NA,
  effectsize_beta = NA,
  sigma2 = 0,
  typeIerror = 0.05,
  alpha0 = 0.1,
  alpha1 = alpha0/2,
  alpha2 = NA
)
}
\arguments{
\item{K}{number of participants at each time period in a cluster, specified as the average clusterperiod size considering cluster-size variability}

\item{design}{I*J dimensional data set that describes the study design (control 0, intervention 1), I is the number of clusters, J is the number of time periods. Unequal allocation of sequences and only complete designs with no transition periods are allowed}

\item{family}{family of responses, specify family="gaussian" for continuous outcome and family="binomial" for binary outcome, with default value of "binomial"}

\item{model}{choose from conditional model (model="conditional") and marginal model (model="marginal"), with default value of applying conditional model}

\item{link}{choose link function from link="identity", link="log" and link="logit", with default value of identity link}

\item{type}{choose the study type, specify type="cohort" for closed cohort study and type="cross-sectional" for cross-sectional study, with default value of cross-sectional study}

\item{meanresponse_start}{the anticipated mean response in the control group at the start of the study}

\item{meanresponse_end0}{the anticipated mean response in the control group at the end of the study, with default value equals to meanresponse_start (no time effects)}

\item{meanresponse_end1}{the anticipated mean response in the intervention group at the end of the study}

\item{effectsize_beta}{the anticipated effect size, just omit this parameter if you don't need to specify it. In all scenarios, you can choose to specify the three parameters about mean responses without specifying this effect size, or alternatively specify meanresponse_start, meanresponse_end0 and this effect size. For continuous outcomes, users can conduct power calculations by only specifying this parameter without the above three parameters about mean responses (as the power is dependent just on it), then calculation will be implemented assuming scenarios without time effects. If you would consider scenarios with time effects and continuous outcomes, please specify meanresponse_start, meanresponse_end0 (donot require accurate information, just make sure they are not equal) and this effectsize_beta.}

\item{sigma2}{marginal variance of the outcome (only needed for continuous outcomes and should not be an input for binary outcomes), with default value of 0.}

\item{typeIerror}{two-sided type I error, with default value of 0.05}

\item{alpha0}{within-period correlation, with default value of 0.1}

\item{alpha1}{between-period correlation, with default value of alpha0/2}

\item{alpha2}{within-individual correlation, should not be an input under cross-sectional designs although it is numerically identical to alpha1 in this scenario by definition}
}
\value{
The object returned has a class of \code{swdpower}, which includes a list of the design matrix and a summary of this design (including the power)
}
\description{
This function performs power calculations for stepped wedge cluster randomized trials under different scenarios. The default setting assumes no time effect; please refer to the documentation for guidance on incorporating time effects.
}
\examples{
library(swdpwr)
#a cross-sectional design with 12 clusters, 3 periods and binary outcomes applying conditional model
#alpha2 should not be specified, as the current version does not support power calculation using
#conditional models with binary outcomes in a cohort design
#create a 12*3 matrix which describes the study design,
#0 means control status, 1 means intervention status
dataset = matrix(c(rep(c(0,1,1),6),rep(c(0,0,1),6)),12,3,byrow=TRUE)

#specify meanresponse_start, meanresponse_end0 and meanresponse_end1
swdpower(K = 30, design = dataset, family = "binomial", model = "conditional", link = "logit",
type = "cross-sectional", meanresponse_start = 0.2, meanresponse_end0 = 0.3,
meanresponse_end1 = 0.4, typeIerror = 0.05, alpha0 = 0.01, alpha1 = 0.01)

#specify meanresponse_start, meanresponse_end0 and effectsize_beta
swdpower(K = 30, design = dataset, family = "binomial", model = "conditional", link = "logit",
type = "cross-sectional", meanresponse_start = 0.2, meanresponse_end0 = 0.3, effectsize_beta = 0.6,
typeIerror = 0.05, alpha0 = 0.01, alpha1 = 0.01)

#a cohort design with 8 clusters, 3 periods and continuous outcomes applying marginal model
#sigma2 should be specified, as continuous outcomes require marginal variance in calculation
#create a 8*3 matrix which describes the study design,
#0 means control status, 1 means intervention status
dataset = matrix(c(rep(c(0,1,1),4),rep(c(0,0,1),4)),8,3, byrow=TRUE)

#specify meanresponse_start, meanresponse_end0 and meanresponse_end1 assuming time effects
swdpower(K = 24, design = dataset, family = "gaussian", model = "marginal", link = "identity",
type = "cohort", meanresponse_start = 0.1, meanresponse_end0 = 0.2,  meanresponse_end1 = 0.4,
sigma2 = 0.095, typeIerror = 0.05, alpha0 = 0.03, alpha1 = 0.015, alpha2 = 0.2)

#specify meanresponse_start, meanresponse_end0 and effectsize_beta assuming time effects.
#As an alternative to the previous example, the time effect specification for meanresponse_start
#and meanresponse_end0 does not need to be precise (make sure they are not equal).
swdpower(K = 24, design = dataset, family = "gaussian", model = "marginal", link = "identity",
type = "cohort", meanresponse_start = 0.1, meanresponse_end0 = 0.2,  effectsize_beta=0.2,
sigma2 = 0.095, typeIerror = 0.05, alpha0 = 0.03, alpha1 = 0.015, alpha2 = 0.2)

#specify effectsize_beta only, then the program runs assuming no time effects
swdpower(K = 24, design = dataset, family = "gaussian", model = "marginal", link = "identity",
type = "cohort",effectsize_beta=0.3, sigma2 = 0.095, typeIerror = 0.05, alpha0 = 0.03,
alpha1 = 0.015, alpha2 = 0.2)
}
