% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_col_motion_metrics.R
\name{col_motion_metrics}
\alias{col_motion_metrics}
\title{Collective Motion Metrics}
\usage{
col_motion_metrics(
  timeseries_data,
  global_metrics,
  step2time = 1,
  verbose = TRUE,
  speed_lim = NA,
  pol_lim = NA,
  noise_thresh = 0
)
}
\arguments{
\item{timeseries_data}{A data frame with time series of individual's
positional data through time with nearest neighbor analysis conducted}

\item{global_metrics}{A data frame with the global metrics timeseries.}

\item{step2time}{Numeric, the sampling frequency of the dataset
(the relation between a time step and real time in seconds).}

\item{verbose}{Logical, whether to post updates on progress.}

\item{speed_lim}{Numeric, the threshold of speed for the definition of
an event. For more info see: \code{\link{pick_threshold}}.}

\item{pol_lim}{Numeric, the threshold of polarization for the definition of
an event. For more info see: \code{\link{pick_threshold}}.}

\item{noise_thresh}{Numeric, the limit of time difference between consecutive
events to be considered the same event. Default value is 0 (no event merging).}
}
\value{
A dataframe with metrics of collective motion per event.
}
\description{
This function calculates metrics of collective motion across sets
and events.
}
\examples{

## A dataframe with group timeseries
g_df <- data.frame(
 t = as.POSIXct(1:25, origin = "2024-03-18 14:56:05"),
 set = rep(1, 25),
 pol = c(rnorm(25)),
 pol_av = c(rnorm(25)),
 speed = c(rnorm(25)),
 speed_av = c(rnorm(25)),
 shape = c(rnorm(25)),
 event = rep(1, 25),
 N = rep(3, 25)
 )

## A dataframe with individual timeseries
p_df <- data.frame(
 t = as.POSIXct(rep(1:25, 3), origin = "2024-03-18 14:56:05"),
 set = rep(1, 75),
 nnd = c(rnorm(75)),
 bangl = runif(75, 0, pi),
 id = c(rep(1, 25), rep(2, 25), rep(3, 25)),
 nn_id = c(
  sample(c(2,3), 25, replace = TRUE),
  sample(c(1,3), 25, replace = TRUE),
  sample(c(2,1), 25, replace = TRUE)),
 event = rep(1, 75)
)
p_df$only_time <- format(p_df$t, "\%H:\%M:\%OS2")

metrics <- col_motion_metrics(
 timeseries_data = p_df,
 global_metrics = g_df,
 step2time = 1,
 speed_lim = 0,
 pol_lim = 0,
 noise_thresh = 1
)

}
\seealso{
\code{\link{define_events}, \link{group_metrics}, \link{pairwise_metrics}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
