% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svinecop_methods.R
\name{svinecop_scores}
\alias{svinecop_scores}
\title{Log-likelihood scores for S-vine copula models}
\usage{
svinecop_scores(u, model, cores = 1)
}
\arguments{
\item{u}{the data; should have approximately uniform margins..}

\item{model}{model inheriting from class \link{svinecop_dist}.}

\item{cores}{number of cores to use; if larger than one, computations are
done in parallel on \code{cores} batches .}
}
\value{
A matrix containing the score vectors in its rows, where each
row corresponds to one observation (row in \code{u}). The columns correspond
to model parameters in the order:
copula parameters of first tree, copula parameters of
second tree, etc. Duplicated parameters in the copula model are omitted.
}
\description{
Log-likelihood scores for S-vine copula models
}
\examples{
# load data set
data(returns)  

# convert to uniform margins
u <- pseudo_obs(returns[1:100, 1:3])

# fit parametric S-vine copula model with Markov order 1
fit <- svinecop(u, p = 1, family_set = "parametric")

svinecop_loglik(u, fit)
svinecop_scores(u, fit)
svinecop_hessian(u, fit)
}
\seealso{
\link{svinecop_hessian}
}
